/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableSampleWithObservable<T>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<?> other;
    final boolean emitLast;

    public ObservableSampleWithObservable(ObservableSource<T> source, ObservableSource<?> other, boolean emitLast) {
        super(source);
        this.other = other;
        this.emitLast = emitLast;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        SerializedObserver<? super T> serial = new SerializedObserver<T>(t);
        if (this.emitLast) {
            this.source.subscribe(new SampleMainEmitLast<T>(serial, this.other));
        } else {
            this.source.subscribe(new SampleMainNoLast<T>(serial, this.other));
        }
    }

    static final class SampleMainEmitLast<T>
    extends SampleMainObserver<T> {
        private static final long serialVersionUID = -3029755663834015785L;
        final AtomicInteger wip = new AtomicInteger();
        volatile boolean done;

        SampleMainEmitLast(Observer<? super T> actual, ObservableSource<?> other) {
            super(actual, other);
        }

        @Override
        void completion() {
            this.done = true;
            if (this.wip.getAndIncrement() == 0) {
                this.emit();
                this.downstream.onComplete();
            }
        }

        @Override
        void run() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    boolean d = this.done;
                    this.emit();
                    if (!d) continue;
                    this.downstream.onComplete();
                    return;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class SampleMainNoLast<T>
    extends SampleMainObserver<T> {
        private static final long serialVersionUID = -3029755663834015785L;

        SampleMainNoLast(Observer<? super T> actual, ObservableSource<?> other) {
            super(actual, other);
        }

        @Override
        void completion() {
            this.downstream.onComplete();
        }

        @Override
        void run() {
            this.emit();
        }
    }

    static final class SamplerObserver<T>
    implements Observer<Object> {
        final SampleMainObserver<T> parent;

        SamplerObserver(SampleMainObserver<T> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.parent.setOther(d);
        }

        @Override
        public void onNext(Object t) {
            this.parent.run();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.error(t);
        }

        @Override
        public void onComplete() {
            this.parent.complete();
        }
    }

    static abstract class SampleMainObserver<T>
    extends AtomicReference<T>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Observer<? super T> downstream;
        final ObservableSource<?> sampler;
        final AtomicReference<Disposable> other = new AtomicReference();
        Disposable upstream;

        SampleMainObserver(Observer<? super T> actual, ObservableSource<?> other) {
            this.downstream = actual;
            this.sampler = other;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                if (this.other.get() == null) {
                    this.sampler.subscribe(new SamplerObserver(this));
                }
            }
        }

        @Override
        public void onNext(T t) {
            this.lazySet(t);
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.other);
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.completion();
        }

        boolean setOther(Disposable o) {
            return DisposableHelper.setOnce(this.other, o);
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.other);
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.other.get() == DisposableHelper.DISPOSED;
        }

        public void error(Throwable e) {
            this.upstream.dispose();
            this.downstream.onError(e);
        }

        public void complete() {
            this.upstream.dispose();
            this.completion();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                this.downstream.onNext(value);
            }
        }

        abstract void completion();

        abstract void run();
    }
}

