/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.file.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetadata;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v2.file.metadata.MetadataIndexNodeV2;

public class TsFileMetadataV2 {
    private TsFileMetadataV2() {
    }

    public static Pair<TsFileMetadata, List<Pair<Long, Long>>> deserializeFrom(ByteBuffer buffer) {
        TsFileMetadata fileMetaData = new TsFileMetadata();
        ArrayList<Pair<Long, Long>> versionInfo = new ArrayList<Pair<Long, Long>>();
        fileMetaData.setMetadataIndex(MetadataIndexNodeV2.deserializeFrom(buffer));
        ReadWriteIOUtils.readInt(buffer);
        ReadWriteIOUtils.readInt(buffer);
        int versionSize = ReadWriteIOUtils.readInt(buffer);
        for (int i = 0; i < versionSize; ++i) {
            long versionPos = ReadWriteIOUtils.readLong(buffer);
            long version = ReadWriteIOUtils.readLong(buffer);
            versionInfo.add(new Pair<Long, Long>(versionPos, version));
        }
        long metaOffset = ReadWriteIOUtils.readLong(buffer);
        fileMetaData.setMetaOffset(metaOffset);
        if (buffer.hasRemaining()) {
            int byteLength = ReadWriteIOUtils.readInt(buffer);
            byte[] bytes = new byte[byteLength];
            buffer.get(bytes);
            int filterSize = ReadWriteIOUtils.readInt(buffer);
            int hashFunctionSize = ReadWriteIOUtils.readInt(buffer);
            fileMetaData.setBloomFilter(BloomFilter.buildBloomFilter(bytes, filterSize, hashFunctionSize));
        }
        return new Pair<TsFileMetadata, List<Pair<Long, Long>>>(fileMetaData, versionInfo);
    }
}

