/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.ReaderNotFoundException;
import org.apache.iotdb.cluster.metadata.CMManager;
import org.apache.iotdb.cluster.metadata.MetaPuller;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.query.filter.SlotTsFileFilter;
import org.apache.iotdb.cluster.query.manage.ClusterQueryManager;
import org.apache.iotdb.cluster.query.reader.ClusterReaderFactory;
import org.apache.iotdb.cluster.query.reader.mult.IMultBatchReader;
import org.apache.iotdb.cluster.rpc.thrift.GetAggrResultRequest;
import org.apache.iotdb.cluster.rpc.thrift.GroupByRequest;
import org.apache.iotdb.cluster.rpc.thrift.LastQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.MeasurementSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.MultSeriesQueryRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PreviousFillRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaRequest;
import org.apache.iotdb.cluster.rpc.thrift.PullSchemaResp;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.cluster.rpc.thrift.SingleSeriesQueryRequest;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.utils.ClusterQueryUtils;
import org.apache.iotdb.cluster.utils.ClusterUtils;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.query.dataset.groupby.GroupByExecutor;
import org.apache.iotdb.db.query.dataset.groupby.LocalGroupByExecutor;
import org.apache.iotdb.db.query.executor.AggregationExecutor;
import org.apache.iotdb.db.query.executor.LastQueryExecutor;
import org.apache.iotdb.db.query.executor.fill.PreviousFill;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.read.reader.IBatchReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.TimeseriesSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalQueryExecutor {
    private static final Logger logger = LoggerFactory.getLogger(LocalQueryExecutor.class);
    public static final String DEBUG_SHOW_QUERY_ID = "{}: local queryId for {}#{} is {}";
    private DataGroupMember dataGroupMember;
    private ClusterReaderFactory readerFactory;
    private String name;
    private ClusterQueryManager queryManager;

    public LocalQueryExecutor(DataGroupMember dataGroupMember) {
        this.dataGroupMember = dataGroupMember;
        this.readerFactory = new ClusterReaderFactory(dataGroupMember.getMetaGroupMember());
        this.name = dataGroupMember.getName();
        this.queryManager = dataGroupMember.getQueryManager();
    }

    private CMManager getCMManager() {
        return (CMManager)IoTDB.metaManager;
    }

    public ByteBuffer fetchSingleSeriesByTimestamps(long readerId, long[] timestamps, int length) throws ReaderNotFoundException, IOException {
        IReaderByTimestamp reader = this.dataGroupMember.getQueryManager().getReaderByTimestamp(readerId);
        if (reader == null) {
            throw new ReaderNotFoundException(readerId);
        }
        Object[] values = reader.getValuesInTimestamps(timestamps, length);
        if (values != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            SerializeUtils.serializeObjects((Object[])values, (DataOutputStream)dataOutputStream);
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        return ByteBuffer.allocate(0);
    }

    public ByteBuffer fetchSingleSeries(long readerId) throws ReaderNotFoundException, IOException {
        IBatchReader reader = this.dataGroupMember.getQueryManager().getReader(readerId);
        if (reader == null) {
            throw new ReaderNotFoundException(readerId);
        }
        if (reader.hasNextBatch()) {
            BatchData batchData = reader.nextBatch();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)dataOutputStream);
            logger.debug("{}: Send results of reader {}, size:{}", new Object[]{this.dataGroupMember.getName(), readerId, batchData.length()});
            return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        return ByteBuffer.allocate(0);
    }

    public Map<String, ByteBuffer> fetchMultSeries(long readerId, List<String> paths) throws ReaderNotFoundException, IOException {
        IMultBatchReader reader = (IMultBatchReader)this.dataGroupMember.getQueryManager().getReader(readerId);
        if (reader == null) {
            throw new ReaderNotFoundException(readerId);
        }
        HashMap pathByteBuffers = Maps.newHashMap();
        for (String path : paths) {
            ByteBuffer byteBuffer;
            if (reader.hasNextBatch(path)) {
                BatchData batchData = reader.nextBatch(path);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                SerializeUtils.serializeBatchData((BatchData)batchData, (DataOutputStream)dataOutputStream);
                logger.debug("{}: Send results of reader {}, size:{}", new Object[]{this.dataGroupMember.getName(), readerId, batchData.length()});
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            } else {
                byteBuffer = ByteBuffer.allocate(0);
            }
            pathByteBuffers.put(path, byteBuffer);
        }
        return pathByteBuffers;
    }

    public long querySingleSeries(SingleSeriesQueryRequest request) throws CheckConsistencyException, QueryProcessException, StorageEngineException, IOException, MetadataException {
        logger.debug("{}: {} is querying {}, queryId: {}", new Object[]{this.name, request.getRequester(), request.getPath(), request.getQueryId()});
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        MeasurementPath path = ClusterQueryUtils.getAssembledPathFromRequest(request.getPath(), (byte)request.getDataTypeOrdinal());
        path.setMeasurementSchema(IoTDB.metaManager.getSeriesSchema((PartialPath)path));
        TSDataType dataType = TSDataType.values()[request.getDataTypeOrdinal()];
        Filter timeFilter = null;
        Filter valueFilter = null;
        if (request.isSetTimeFilterBytes()) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)request.timeFilterBytes);
        }
        if (request.isSetValueFilterBytes()) {
            valueFilter = FilterFactory.deserialize((ByteBuffer)request.valueFilterBytes);
        }
        Set deviceMeasurements = request.getDeviceMeasurements();
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(request.getRequester(), request.getQueryId());
        logger.debug(DEBUG_SHOW_QUERY_ID, new Object[]{this.name, request.getQueryId(), request.getPath(), queryContext.getQueryId()});
        IBatchReader batchReader = this.readerFactory.getSeriesBatchReader((PartialPath)path, deviceMeasurements, dataType, timeFilter, valueFilter, queryContext, this.dataGroupMember, request.ascending, request.requiredSlots);
        if (batchReader != null && batchReader.hasNextBatch()) {
            long readerId = this.queryManager.registerReader(batchReader);
            queryContext.registerLocalReader(readerId);
            logger.debug("{}: Build a reader of {} for {}#{}, readerId: {}", new Object[]{this.name, path, request.getRequester(), request.getQueryId(), readerId});
            return readerId;
        }
        logger.debug("{}: There is no data of {} for {}#{}", new Object[]{this.name, path, request.getRequester(), request.getQueryId()});
        if (batchReader != null) {
            batchReader.close();
        }
        return -1L;
    }

    public long queryMultSeries(MultSeriesQueryRequest request) throws CheckConsistencyException, QueryProcessException, StorageEngineException, IOException, MetadataException {
        logger.debug("{}: {} is querying {}, queryId: {}", new Object[]{this.name, request.getRequester(), request.getPath(), request.getQueryId()});
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        ArrayList paths = Lists.newArrayList();
        ArrayList dataTypes = Lists.newArrayList();
        for (int i = 0; i < request.getPath().size(); ++i) {
            MeasurementPath path = ClusterQueryUtils.getAssembledPathFromRequest((String)request.getPath().get(i), ((Integer)request.getDataTypeOrdinal().get(i)).byteValue());
            path.setMeasurementSchema(IoTDB.metaManager.getSeriesSchema((PartialPath)path));
            paths.add(path);
            dataTypes.add(TSDataType.values()[(Integer)request.getDataTypeOrdinal().get(i)]);
        }
        Filter timeFilter = null;
        Filter valueFilter = null;
        if (request.isSetTimeFilterBytes()) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)request.timeFilterBytes);
        }
        if (request.isSetValueFilterBytes()) {
            valueFilter = FilterFactory.deserialize((ByteBuffer)request.valueFilterBytes);
        }
        Map deviceMeasurements = request.getDeviceMeasurements();
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(request.getRequester(), request.getQueryId());
        logger.debug(DEBUG_SHOW_QUERY_ID, new Object[]{this.name, request.getQueryId(), request.getPath(), queryContext.getQueryId()});
        IBatchReader batchReader = this.readerFactory.getMultSeriesBatchReader(paths, deviceMeasurements, dataTypes, timeFilter, valueFilter, queryContext, this.dataGroupMember, request.ascending);
        if (batchReader != null && batchReader.hasNextBatch()) {
            long readerId = this.queryManager.registerReader(batchReader);
            queryContext.registerLocalReader(readerId);
            logger.debug("{}: Build a reader of {} for {}#{}, readerId: {}", new Object[]{this.name, paths, request.getRequester(), request.getQueryId(), readerId});
            return readerId;
        }
        logger.debug("{}: There is no data of {} for {}#{}", new Object[]{this.name, paths, request.getRequester(), request.getQueryId()});
        if (batchReader != null) {
            batchReader.close();
        }
        return -1L;
    }

    public PullSchemaResp queryTimeSeriesSchema(PullSchemaRequest request) throws CheckConsistencyException, MetadataException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        List prefixPaths = request.getPrefixPaths();
        ArrayList<TimeseriesSchema> timeseriesSchemas = new ArrayList<TimeseriesSchema>();
        this.collectTimeseriesSchema(prefixPaths, timeseriesSchemas);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Collected {} schemas for {} and other {} paths", new Object[]{this.name, timeseriesSchemas.size(), prefixPaths.get(0), prefixPaths.size() - 1});
        }
        PullSchemaResp resp = new PullSchemaResp();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(timeseriesSchemas.size());
            for (TimeseriesSchema timeseriesSchema : timeseriesSchemas) {
                timeseriesSchema.serializeTo((OutputStream)dataOutputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        resp.setSchemaBytes(byteArrayOutputStream.toByteArray());
        return resp;
    }

    public PullSchemaResp queryMeasurementSchema(PullSchemaRequest request) throws CheckConsistencyException, MetadataException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        List prefixPaths = request.getPrefixPaths();
        ArrayList<IMeasurementSchema> measurementSchemas = new ArrayList<IMeasurementSchema>();
        this.collectSeries(prefixPaths, measurementSchemas);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Collected {} schemas for {} and other {} paths", new Object[]{this.name, measurementSchemas.size(), prefixPaths.get(0), prefixPaths.size() - 1});
        }
        PullSchemaResp resp = new PullSchemaResp();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(measurementSchemas.size());
            for (IMeasurementSchema timeseriesSchema : measurementSchemas) {
                timeseriesSchema.partialSerializeTo((OutputStream)dataOutputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        resp.setSchemaBytes(byteArrayOutputStream.toByteArray());
        return resp;
    }

    private void collectSeries(List<String> prefixPaths, List<IMeasurementSchema> measurementSchemas) throws MetadataException {
        HashMap<PartitionGroup, List> prePartitionGroupPathMap = new HashMap<PartitionGroup, List>();
        RaftNode header = this.dataGroupMember.getHeader();
        Map<Integer, PartitionGroup> slotPreviousHolderMap = ((SlotPartitionTable)this.dataGroupMember.getMetaGroupMember().getPartitionTable()).getPreviousNodeMap().get(header);
        for (String string : prefixPaths) {
            int slot = ClusterUtils.getSlotByPathTimeWithSync(new PartialPath(string), this.dataGroupMember.getMetaGroupMember());
            if (this.dataGroupMember.getSlotManager().checkSlotInMetaMigrationStatus(slot) && slotPreviousHolderMap.containsKey(slot)) {
                prePartitionGroupPathMap.computeIfAbsent(slotPreviousHolderMap.get(slot), s -> new ArrayList()).add(new PartialPath(string));
                continue;
            }
            this.getCMManager().collectMeasurementSchema(new PartialPath(string), measurementSchemas);
        }
        if (prePartitionGroupPathMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : prePartitionGroupPathMap.entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)entry.getKey();
            List paths = (List)entry.getValue();
            MetaPuller.getInstance().pullMeasurementSchemas(partitionGroup, paths, measurementSchemas);
        }
    }

    private void collectTimeseriesSchema(List<String> prefixPaths, List<TimeseriesSchema> timeseriesSchemas) throws MetadataException {
        HashMap<PartitionGroup, List> prePartitionGroupPathMap = new HashMap<PartitionGroup, List>();
        RaftNode header = this.dataGroupMember.getHeader();
        Map<Integer, PartitionGroup> slotPreviousHolderMap = ((SlotPartitionTable)this.dataGroupMember.getMetaGroupMember().getPartitionTable()).getPreviousNodeMap().get(header);
        for (String string : prefixPaths) {
            int slot = ClusterUtils.getSlotByPathTimeWithSync(new PartialPath(string), this.dataGroupMember.getMetaGroupMember());
            if (this.dataGroupMember.getSlotManager().checkSlotInMetaMigrationStatus(slot) && slotPreviousHolderMap.containsKey(slot)) {
                prePartitionGroupPathMap.computeIfAbsent(slotPreviousHolderMap.get(slot), s -> new ArrayList()).add(string);
                continue;
            }
            this.getCMManager().collectTimeseriesSchema(new PartialPath(string), timeseriesSchemas);
        }
        if (prePartitionGroupPathMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : prePartitionGroupPathMap.entrySet()) {
            PartitionGroup partitionGroup = (PartitionGroup)entry.getKey();
            List paths = (List)entry.getValue();
            MetaPuller.getInstance().pullTimeSeriesSchemas(partitionGroup, paths, timeseriesSchemas);
        }
    }

    public long querySingleSeriesByTimestamp(SingleSeriesQueryRequest request) throws CheckConsistencyException, QueryProcessException, StorageEngineException, MetadataException {
        logger.debug("{}: {} is querying {} by timestamp, queryId: {}", new Object[]{this.name, request.getRequester(), request.getPath(), request.getQueryId()});
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        MeasurementPath path = ClusterQueryUtils.getAssembledPathFromRequest(request.getPath(), (byte)request.getDataTypeOrdinal());
        path.setMeasurementSchema(IoTDB.metaManager.getSeriesSchema((PartialPath)path));
        TSDataType dataType = TSDataType.values()[request.dataTypeOrdinal];
        Set deviceMeasurements = request.getDeviceMeasurements();
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(request.getRequester(), request.getQueryId());
        logger.debug(DEBUG_SHOW_QUERY_ID, new Object[]{this.name, request.getQueryId(), request.getPath(), queryContext.getQueryId()});
        IReaderByTimestamp readerByTimestamp = this.readerFactory.getReaderByTimestamp((PartialPath)path, deviceMeasurements, dataType, queryContext, this.dataGroupMember, request.ascending, request.requiredSlots);
        if (readerByTimestamp != null) {
            long readerId = this.queryManager.registerReaderByTime(readerByTimestamp);
            queryContext.registerLocalReader(readerId);
            logger.debug("{}: Build a readerByTimestamp of {} for {}, readerId: {}", new Object[]{this.name, path, request.getRequester(), readerId});
            return readerId;
        }
        logger.debug("{}: There is no data {} for {}#{}", new Object[]{this.name, path, request.getRequester(), request.getQueryId()});
        return -1L;
    }

    public ByteBuffer getAllMeasurementSchema(MeasurementSchemaRequest request) throws CheckConsistencyException, IOException, MetadataException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        ShowTimeSeriesPlan plan = (ShowTimeSeriesPlan)PhysicalPlan.Factory.create((ByteBuffer)request.planBinary);
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(request.getRequester(), request.getQueryId());
        List<ShowTimeSeriesResult> allTimeseriesSchema = this.getCMManager().showLocalTimeseries(plan, queryContext);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
            dataOutputStream.writeInt(allTimeseriesSchema.size());
            for (ShowTimeSeriesResult result : allTimeseriesSchema) {
                result.serialize((OutputStream)outputStream);
            }
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    public ByteBuffer getDevices(ByteBuffer planBuffer) throws CheckConsistencyException, IOException, MetadataException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        ShowDevicesPlan plan = (ShowDevicesPlan)PhysicalPlan.Factory.create((ByteBuffer)planBuffer);
        List<ShowDevicesResult> allDevicesResult = this.getCMManager().getLocalDevices(plan);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(outputStream);){
            dataOutputStream.writeInt(allDevicesResult.size());
            for (ShowDevicesResult result : allDevicesResult) {
                result.serialize((OutputStream)outputStream);
            }
        }
        return ByteBuffer.wrap(outputStream.toByteArray());
    }

    public List<ByteBuffer> getAggrResult(GetAggrResultRequest request) throws StorageEngineException, QueryProcessException, IOException {
        MeasurementPath path;
        logger.debug("{}: {} is querying {} by aggregation, queryId: {}", new Object[]{this.name, request.getRequestor(), request.getPath(), request.getQueryId()});
        List aggregations = request.getAggregations();
        TSDataType dataType = TSDataType.values()[request.getDataTypeOrdinal()];
        try {
            path = new MeasurementPath(request.getPath(), dataType);
        }
        catch (IllegalPathException e) {
            logger.error("{}: aggregation has error path: {}, queryId: {}", new Object[]{this.name, request.getPath(), request.getQueryId()});
            throw new QueryProcessException((IoTDBException)e);
        }
        Filter timeFilter = null;
        if (request.isSetTimeFilterBytes()) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)request.timeFilterBytes);
        }
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(request.getRequestor(), request.queryId);
        Set deviceMeasurements = request.getDeviceMeasurements();
        boolean ascending = request.ascending;
        List<AggregateResult> results = this.getAggrResult(aggregations, deviceMeasurements, dataType, (PartialPath)path, timeFilter, queryContext, ascending);
        logger.trace("{}: aggregation results {}, queryId: {}", new Object[]{this.name, results, request.getQueryId()});
        ArrayList<ByteBuffer> resultBuffers = new ArrayList<ByteBuffer>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (AggregateResult result : results) {
            try {
                result.serializeTo((OutputStream)byteArrayOutputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            resultBuffers.add(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            byteArrayOutputStream.reset();
        }
        return resultBuffers;
    }

    public List<AggregateResult> getAggrResult(List<String> aggregations, Set<String> allSensors, TSDataType dataType, PartialPath path, Filter timeFilter, QueryContext context, boolean ascending) throws IOException, StorageEngineException, QueryProcessException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new QueryProcessException(e.getMessage());
        }
        ArrayList<AggregateResult> results = new ArrayList<AggregateResult>();
        ArrayList<AggregateResult> ascResults = new ArrayList<AggregateResult>();
        ArrayList<AggregateResult> descResults = new ArrayList<AggregateResult>();
        for (String aggregation : aggregations) {
            AggregateResult ar = AggregateResultFactory.getAggrResultByName((String)aggregation, (TSDataType)dataType, (boolean)ascending);
            if (ar.isAscending()) {
                ascResults.add(ar);
            } else {
                descResults.add(ar);
            }
            results.add(ar);
        }
        List<Integer> nodeSlots = ((SlotPartitionTable)this.dataGroupMember.getMetaGroupMember().getPartitionTable()).getNodeSlots(this.dataGroupMember.getHeader());
        AggregationExecutor.aggregateOneSeries((PartialPath)path, allSensors, (QueryContext)context, (Filter)timeFilter, (TSDataType)dataType, ascResults, descResults, (TsFileFilter)new SlotTsFileFilter(nodeSlots), (boolean)ascending);
        return results;
    }

    public List<String> getUnregisteredTimeseries(List<String> timeseriesList) throws CheckConsistencyException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(true);
        ArrayList<String> result = new ArrayList<String>();
        for (String seriesPath : timeseriesList) {
            try {
                List path = this.getCMManager().getMeasurementPaths(new PartialPath(seriesPath));
                if (path.size() == 1) continue;
                throw new MetadataException(String.format("Timeseries number of the name [%s] is not 1.", seriesPath));
            }
            catch (MetadataException e) {
                result.add(seriesPath);
            }
        }
        return result;
    }

    public LocalGroupByExecutor getGroupByExecutor(PartialPath path, Set<String> deviceMeasurements, TSDataType dataType, Filter timeFilter, List<Integer> aggregationTypes, QueryContext context, boolean ascending) throws StorageEngineException, QueryProcessException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        List<Integer> nodeSlots = ((SlotPartitionTable)this.dataGroupMember.getMetaGroupMember().getPartitionTable()).getNodeSlots(this.dataGroupMember.getHeader());
        LocalGroupByExecutor executor = new LocalGroupByExecutor(path, deviceMeasurements, context, timeFilter, (TsFileFilter)new SlotTsFileFilter(nodeSlots), ascending);
        for (Integer aggregationType : aggregationTypes) {
            executor.addAggregateResult(AggregateResultFactory.getAggrResultByType((AggregationType)AggregationType.values()[aggregationType], (TSDataType)dataType, (boolean)ascending));
        }
        return executor;
    }

    public long getGroupByExecutor(GroupByRequest request) throws QueryProcessException, StorageEngineException {
        boolean isEmpty;
        MeasurementPath path;
        List aggregationTypeOrdinals = request.getAggregationTypeOrdinals();
        TSDataType dataType = TSDataType.values()[request.getDataTypeOrdinal()];
        try {
            path = new MeasurementPath(request.getPath(), dataType);
        }
        catch (IllegalPathException e) {
            throw new QueryProcessException((IoTDBException)e);
        }
        Filter timeFilter = null;
        if (request.isSetTimeFilterBytes()) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)request.timeFilterBytes);
        }
        long queryId = request.getQueryId();
        logger.debug("{}: {} is querying {} using group by, queryId: {}", new Object[]{this.name, request.getRequestor(), path, queryId});
        Set deviceMeasurements = request.getDeviceMeasurements();
        boolean ascending = request.ascending;
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(request.getRequestor(), queryId);
        LocalGroupByExecutor executor = this.getGroupByExecutor((PartialPath)path, deviceMeasurements, dataType, timeFilter, aggregationTypeOrdinals, queryContext, ascending);
        try {
            isEmpty = executor.isEmpty();
        }
        catch (IOException e) {
            logger.error("Something wrong happened", (Throwable)e);
            throw new QueryProcessException((Throwable)e, TSStatusCode.INTERNAL_SERVER_ERROR.ordinal());
        }
        if (!isEmpty) {
            long executorId = this.queryManager.registerGroupByExecutor((GroupByExecutor)executor);
            logger.debug("{}: Build a GroupByExecutor of {} for {}, executorId: {}", new Object[]{this.name, path, request.getRequestor(), executor});
            queryContext.registerLocalGroupByExecutor(executorId);
            return executorId;
        }
        logger.debug("{}: There is no data {} for {}#{}", new Object[]{this.name, path, request.getRequestor(), request.getQueryId()});
        return -1L;
    }

    public List<ByteBuffer> getGroupByResult(long executorId, long startTime, long endTime) throws ReaderNotFoundException, IOException, QueryProcessException {
        GroupByExecutor executor = this.queryManager.getGroupByExecutor(executorId);
        if (executor == null) {
            throw new ReaderNotFoundException(executorId);
        }
        List results = executor.calcResult(startTime, endTime);
        ArrayList<ByteBuffer> resultBuffers = new ArrayList<ByteBuffer>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (AggregateResult result : results) {
            result.serializeTo((OutputStream)byteArrayOutputStream);
            resultBuffers.add(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
            byteArrayOutputStream.reset();
        }
        logger.debug("{}: Send results of group by executor {}, size:{}", new Object[]{this.name, executor, resultBuffers.size()});
        return resultBuffers;
    }

    public ByteBuffer peekNextNotNullValue(long executorId, long startTime, long endTime) throws ReaderNotFoundException, IOException {
        ByteBuffer resultBuffer;
        GroupByExecutor executor = this.queryManager.getGroupByExecutor(executorId);
        if (executor == null) {
            throw new ReaderNotFoundException(executorId);
        }
        Pair pair = executor.peekNextNotNullValue(startTime, endTime);
        if (pair == null) {
            pair = new Pair((Object)0L, null);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            dataOutputStream.writeLong((Long)pair.left);
            SerializeUtils.serializeObject((Object)pair.right, (DataOutputStream)dataOutputStream);
            resultBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        }
        logger.debug("{}: Send results of group by executor {}, size:{}", new Object[]{this.name, executor, resultBuffer.limit()});
        return resultBuffer;
    }

    public ByteBuffer previousFill(PreviousFillRequest request) throws QueryProcessException, StorageEngineException, IOException, IllegalPathException {
        TSDataType dataType = TSDataType.values()[request.getDataTypeOrdinal()];
        MeasurementPath path = new MeasurementPath(request.getPath(), dataType);
        long queryId = request.getQueryId();
        long queryTime = request.getQueryTime();
        long beforeRange = request.getBeforeRange();
        Node requester = request.getRequester();
        Set deviceMeasurements = request.getDeviceMeasurements();
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(requester, queryId);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        TimeValuePair timeValuePair = this.localPreviousFill((PartialPath)path, dataType, queryTime, beforeRange, deviceMeasurements, queryContext);
        SerializeUtils.serializeTVPair((TimeValuePair)timeValuePair, (DataOutputStream)dataOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public TimeValuePair localPreviousFill(PartialPath path, TSDataType dataType, long queryTime, long beforeRange, Set<String> deviceMeasurements, QueryContext context) throws QueryProcessException, StorageEngineException, IOException {
        try {
            this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new QueryProcessException(e.getMessage());
        }
        PreviousFill previousFill = new PreviousFill(dataType, queryTime, beforeRange);
        previousFill.configureFill(path, dataType, queryTime, deviceMeasurements, context);
        return previousFill.getFillResult();
    }

    public int getPathCount(List<String> pathsToQuery, int level) throws CheckConsistencyException, MetadataException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        int count = 0;
        for (String s : pathsToQuery) {
            if (level == -1) {
                count += this.getCMManager().getAllTimeseriesCount(new PartialPath(s));
                continue;
            }
            count += this.getCMManager().getNodesCountInGivenLevel(new PartialPath(s), level);
        }
        return count;
    }

    public int getDeviceCount(List<String> pathsToQuery) throws CheckConsistencyException, MetadataException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        int count = 0;
        for (String s : pathsToQuery) {
            count += this.getCMManager().getDevicesNum(new PartialPath(s));
        }
        return count;
    }

    public ByteBuffer last(LastQueryRequest request) throws CheckConsistencyException, QueryProcessException, IOException, StorageEngineException, MetadataException {
        this.dataGroupMember.syncLeaderWithConsistencyCheck(false);
        RemoteQueryContext queryContext = this.queryManager.getQueryContext(request.getRequestor(), request.getQueryId());
        ArrayList<MeasurementPath> seriesPaths = new ArrayList<MeasurementPath>();
        for (Object path : request.getPaths()) {
            PartialPath partialPath = new PartialPath((String)path);
            seriesPaths.add(new MeasurementPath(partialPath, IoTDB.metaManager.getSeriesSchema(partialPath)));
        }
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>(request.dataTypeOrdinals.size());
        for (Integer dataTypeOrdinal : request.dataTypeOrdinals) {
            dataTypes.add(TSDataType.values()[dataTypeOrdinal]);
        }
        GlobalTimeExpression expression = null;
        if (request.isSetFilterBytes()) {
            Filter filter = FilterFactory.deserialize((ByteBuffer)request.filterBytes);
            expression = new GlobalTimeExpression(filter);
        }
        List timeValuePairs = LastQueryExecutor.calculateLastPairForSeriesLocally(seriesPaths, dataTypes, (QueryContext)queryContext, expression, (Map)request.getDeviceMeasurements());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (Pair timeValuePair : timeValuePairs) {
            SerializeUtils.serializeTVPair((TimeValuePair)((TimeValuePair)timeValuePair.right), (DataOutputStream)dataOutputStream);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }
}

