/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.reporter;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.netty.channel.ChannelOption;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.http.server.HttpServer;

public class MicrometerPrometheusReporter
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrometerPrometheusReporter.class);
    private static final MetricConfig metricConfig = MetricConfigDescriptor.getInstance().getMetricConfig();
    private AbstractMetricManager metricManager;
    private DisposableServer httpServer;

    public boolean start() {
        PrometheusMeterRegistry prometheusMeterRegistry;
        if (this.httpServer != null) {
            return false;
        }
        Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(reporter -> reporter instanceof PrometheusMeterRegistry).collect(Collectors.toSet());
        if (meterRegistrySet.size() == 0) {
            prometheusMeterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            prometheusMeterRegistry.throwExceptionOnRegistrationFailure();
            Metrics.addRegistry((MeterRegistry)prometheusMeterRegistry);
        } else {
            prometheusMeterRegistry = (PrometheusMeterRegistry)meterRegistrySet.toArray()[0];
        }
        this.httpServer = ((HttpServer)HttpServer.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)2000)).channelGroup((ChannelGroup)new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE)).port(metricConfig.getPrometheusExporterPort().intValue()).route(routes -> routes.get("/metrics", (request, response) -> response.sendString((Publisher)Mono.just((Object)prometheusMeterRegistry.scrape())))).bindNow();
        LOGGER.info("http server for metrics started, listen on {}", (Object)metricConfig.getPrometheusExporterPort());
        return true;
    }

    public boolean stop() {
        if (this.httpServer != null) {
            try {
                Set meterRegistrySet = Metrics.globalRegistry.getRegistries().stream().filter(reporter -> reporter instanceof PrometheusMeterRegistry).collect(Collectors.toSet());
                for (MeterRegistry meterRegistry : meterRegistrySet) {
                    meterRegistry.close();
                    Metrics.removeRegistry((MeterRegistry)meterRegistry);
                }
                this.httpServer.disposeNow();
                this.httpServer = null;
            }
            catch (Exception e) {
                LOGGER.error("failed to stop server", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.PROMETHEUS;
    }

    public void setMetricManager(AbstractMetricManager metricManager) {
        this.metricManager = metricManager;
    }
}

