/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.read.auth;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.ConfigPhysicalReadPlan;

public class AuthorReadPlan
extends ConfigPhysicalReadPlan {
    private final ConfigPhysicalPlanType authorType;
    private final String roleName;
    private String password;
    private final String newPassword;
    private Set<Integer> permissions;
    private final List<PartialPath> nodeNameList;
    private String userName;
    private final boolean grantOpt;

    public AuthorReadPlan(ConfigPhysicalPlanType authorType, String userName, String roleName, String password, String newPassword, Set<Integer> permissions, boolean grantOpt, List<PartialPath> nodeNameList) {
        super(authorType);
        this.authorType = authorType;
        this.userName = userName;
        this.roleName = roleName;
        this.password = password;
        this.newPassword = newPassword;
        this.permissions = permissions;
        this.grantOpt = grantOpt;
        this.nodeNameList = nodeNameList;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<Integer> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Integer> permissions) {
        this.permissions = permissions;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorReadPlan that = (AuthorReadPlan)o;
        return Objects.equals((Object)this.authorType, (Object)that.authorType) && Objects.equals(this.userName, that.userName) && Objects.equals(this.roleName, that.roleName) && Objects.equals(this.password, that.password) && Objects.equals(this.newPassword, that.newPassword) && Objects.equals(this.permissions, that.permissions) && this.grantOpt == that.grantOpt && Objects.equals(this.nodeNameList, that.nodeNameList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.authorType, this.userName, this.roleName, this.password, this.newPassword, this.permissions, this.nodeNameList, this.grantOpt});
    }

    public String toString() {
        return "[type:" + (Object)((Object)this.authorType) + ", username:" + this.userName + ", rolename:" + this.roleName + ", permissions:" + PrivilegeType.toPriType(this.permissions) + ", grant option:" + this.grantOpt + ", paths:" + this.nodeNameList + "]";
    }
}

