/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.record;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class Tablet {
    private static final int DEFAULT_SIZE = 1024;
    private static final String NOT_SUPPORT_DATATYPE = "Data type %s is not supported.";
    public String deviceId;
    private List<MeasurementSchema> schemas;
    private final Map<String, Integer> measurementIndex;
    public long[] timestamps;
    public Object[] values;
    public BitMap[] bitMaps;
    public int rowSize;
    private final int maxRowNumber;

    public Tablet(String deviceId, List<MeasurementSchema> schemas) {
        this(deviceId, schemas, 1024);
    }

    public Tablet(String deviceId, List<MeasurementSchema> schemas, int maxRowNumber) {
        this.deviceId = deviceId;
        this.schemas = new ArrayList<MeasurementSchema>(schemas);
        this.maxRowNumber = maxRowNumber;
        this.measurementIndex = new HashMap<String, Integer>();
        this.constructMeasurementIndexMap();
        this.createColumns();
        this.reset();
    }

    public Tablet(String deviceId, List<MeasurementSchema> schemas, long[] timestamps, Object[] values, BitMap[] bitMaps, int maxRowNumber) {
        this.deviceId = deviceId;
        this.schemas = schemas;
        this.timestamps = timestamps;
        this.values = values;
        this.bitMaps = bitMaps;
        this.maxRowNumber = maxRowNumber;
        this.rowSize = maxRowNumber;
        this.measurementIndex = new HashMap<String, Integer>();
        this.constructMeasurementIndexMap();
    }

    private void constructMeasurementIndexMap() {
        int indexInSchema = 0;
        for (MeasurementSchema schema : this.schemas) {
            this.measurementIndex.put(schema.getMeasurementId(), indexInSchema);
            ++indexInSchema;
        }
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setSchemas(List<MeasurementSchema> schemas) {
        this.schemas = schemas;
    }

    public void initBitMaps() {
        this.bitMaps = new BitMap[this.schemas.size()];
        for (int column = 0; column < this.schemas.size(); ++column) {
            this.bitMaps[column] = new BitMap(this.getMaxRowNumber());
        }
    }

    public void addTimestamp(int rowIndex, long timestamp) {
        this.timestamps[rowIndex] = timestamp;
    }

    public void addValue(String measurementId, int rowIndex, Object value) {
        int indexOfSchema = this.measurementIndex.get(measurementId);
        MeasurementSchema measurementSchema = this.schemas.get(indexOfSchema);
        this.addValueOfDataType(measurementSchema.getType(), rowIndex, indexOfSchema, value);
    }

    private void addValueOfDataType(TSDataType dataType, int rowIndex, int indexOfSchema, Object value) {
        if (value == null) {
            if (this.bitMaps == null) {
                this.bitMaps = new BitMap[this.values.length];
            }
            if (this.bitMaps[indexOfSchema] == null) {
                this.bitMaps[indexOfSchema] = new BitMap(this.maxRowNumber);
            }
            this.bitMaps[indexOfSchema].mark(rowIndex);
        }
        switch (dataType) {
            case TEXT: 
            case STRING: {
                Binary[] sensor = (Binary[])this.values[indexOfSchema];
                if (value instanceof Binary) {
                    sensor[rowIndex] = (Binary)value;
                    break;
                }
                sensor[rowIndex] = value != null ? new Binary((String)value, TSFileConfig.STRING_CHARSET) : Binary.EMPTY_VALUE;
                break;
            }
            case BLOB: {
                Binary[] sensor = (Binary[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Binary)value : Binary.EMPTY_VALUE;
                break;
            }
            case FLOAT: {
                float[] sensor = (float[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? ((Float)value).floatValue() : Float.MIN_VALUE;
                break;
            }
            case INT32: {
                int[] sensor = (int[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Integer)value : Integer.MIN_VALUE;
                break;
            }
            case DATE: {
                LocalDate[] sensor = (LocalDate[])this.values[indexOfSchema];
                sensor[rowIndex] = (LocalDate)value;
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] sensor = (long[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Long)value : Long.MIN_VALUE;
                break;
            }
            case DOUBLE: {
                double[] sensor = (double[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null ? (Double)value : Double.MIN_VALUE;
                break;
            }
            case BOOLEAN: {
                boolean[] sensor = (boolean[])this.values[indexOfSchema];
                sensor[rowIndex] = value != null && (Boolean)value != false;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, dataType));
            }
        }
    }

    public List<MeasurementSchema> getSchemas() {
        return this.schemas;
    }

    public int getMaxRowNumber() {
        return this.maxRowNumber;
    }

    public void reset() {
        this.rowSize = 0;
        if (this.bitMaps != null) {
            for (BitMap bitMap : this.bitMaps) {
                if (bitMap == null) continue;
                bitMap.reset();
            }
        }
    }

    private void createColumns() {
        this.timestamps = new long[this.maxRowNumber];
        int valueColumnsSize = this.schemas.size();
        this.values = new Object[valueColumnsSize];
        int columnIndex = 0;
        for (MeasurementSchema schema : this.schemas) {
            TSDataType dataType = schema.getType();
            this.values[columnIndex] = this.createValueColumnOfDataType(dataType);
            ++columnIndex;
        }
    }

    private Object createValueColumnOfDataType(TSDataType dataType) {
        Object[] valueColumn;
        switch (dataType) {
            case INT32: {
                valueColumn = new int[this.maxRowNumber];
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                valueColumn = new long[this.maxRowNumber];
                break;
            }
            case FLOAT: {
                valueColumn = new float[this.maxRowNumber];
                break;
            }
            case DOUBLE: {
                valueColumn = new double[this.maxRowNumber];
                break;
            }
            case BOOLEAN: {
                valueColumn = new boolean[this.maxRowNumber];
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                valueColumn = new Binary[this.maxRowNumber];
                break;
            }
            case DATE: {
                valueColumn = new LocalDate[this.maxRowNumber];
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, dataType));
            }
        }
        return valueColumn;
    }

    public int getTimeBytesSize() {
        return this.rowSize * 8;
    }

    public int getTotalValueOccupation() {
        int valueOccupation = 0;
        int columnIndex = 0;
        for (MeasurementSchema schema : this.schemas) {
            valueOccupation += this.calOccupationOfOneColumn(schema.getType(), columnIndex);
            ++columnIndex;
        }
        if (this.bitMaps != null) {
            for (BitMap bitMap : this.bitMaps) {
                ++valueOccupation;
                if (bitMap == null || bitMap.isAllUnmarked()) continue;
                valueOccupation += this.rowSize / 8 + 1;
            }
        }
        return valueOccupation;
    }

    private int calOccupationOfOneColumn(TSDataType dataType, int columnIndex) {
        int valueOccupation = 0;
        switch (dataType) {
            case BOOLEAN: {
                valueOccupation += this.rowSize;
                break;
            }
            case FLOAT: 
            case INT32: 
            case DATE: {
                valueOccupation += this.rowSize * 4;
                break;
            }
            case INT64: 
            case TIMESTAMP: 
            case DOUBLE: {
                valueOccupation += this.rowSize * 8;
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                valueOccupation += this.rowSize * 4;
                Binary[] binaries = (Binary[])this.values[columnIndex];
                for (int rowIndex = 0; rowIndex < this.rowSize; ++rowIndex) {
                    valueOccupation += binaries[rowIndex].getLength();
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, dataType));
            }
        }
        return valueOccupation;
    }

    public ByteBuffer serialize() throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
                this.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.deviceId, (OutputStream)stream);
        ReadWriteIOUtils.write(this.rowSize, (OutputStream)stream);
        this.writeMeasurementSchemas(stream);
        this.writeTimes(stream);
        this.writeBitMaps(stream);
        this.writeValues(stream);
    }

    private void writeMeasurementSchemas(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.schemas != null), (OutputStream)stream);
        if (this.schemas != null) {
            ReadWriteIOUtils.write(this.schemas.size(), (OutputStream)stream);
            for (MeasurementSchema schema : this.schemas) {
                if (schema == null) {
                    ReadWriteIOUtils.write(BytesUtils.boolToByte(false), (OutputStream)stream);
                    continue;
                }
                ReadWriteIOUtils.write(BytesUtils.boolToByte(true), (OutputStream)stream);
                schema.serializeTo(stream);
            }
        }
    }

    private void writeTimes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.timestamps != null), (OutputStream)stream);
        if (this.timestamps != null) {
            for (int i = 0; i < this.rowSize; ++i) {
                ReadWriteIOUtils.write(this.timestamps[i], (OutputStream)stream);
            }
        }
    }

    private void writeBitMaps(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.bitMaps != null), (OutputStream)stream);
        if (this.bitMaps != null) {
            int size = this.schemas == null ? 0 : this.schemas.size();
            for (int i = 0; i < size; ++i) {
                if (this.bitMaps[i] == null) {
                    ReadWriteIOUtils.write(BytesUtils.boolToByte(false), (OutputStream)stream);
                    continue;
                }
                ReadWriteIOUtils.write(BytesUtils.boolToByte(true), (OutputStream)stream);
                ReadWriteIOUtils.write(this.bitMaps[i].getSize(), (OutputStream)stream);
                ReadWriteIOUtils.write(new Binary(this.bitMaps[i].getByteArray()), (OutputStream)stream);
            }
        }
    }

    private void writeValues(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(this.values != null), (OutputStream)stream);
        if (this.values != null) {
            int size = this.schemas == null ? 0 : this.schemas.size();
            for (int i = 0; i < size; ++i) {
                this.serializeColumn(this.schemas.get(i).getType(), this.values[i], stream);
            }
        }
    }

    private void serializeColumn(TSDataType dataType, Object column, DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(BytesUtils.boolToByte(column != null), (OutputStream)stream);
        if (column != null) {
            switch (dataType) {
                case INT32: {
                    int[] intValues = (int[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(intValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case DATE: {
                    LocalDate[] dateValues = (LocalDate[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(dateValues[j] == null ? 10000101 : DateUtils.parseDateExpressionToInt(dateValues[j]), (OutputStream)stream);
                    }
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] longValues = (long[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(longValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case FLOAT: {
                    float[] floatValues = (float[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(floatValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = (double[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(doubleValues[j], (OutputStream)stream);
                    }
                    break;
                }
                case BOOLEAN: {
                    boolean[] boolValues = (boolean[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(BytesUtils.boolToByte(boolValues[j]), (OutputStream)stream);
                    }
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    Binary[] binaryValues = (Binary[])column;
                    for (int j = 0; j < this.rowSize; ++j) {
                        ReadWriteIOUtils.write(BytesUtils.boolToByte(binaryValues[j] != null), (OutputStream)stream);
                        if (binaryValues[j] == null) continue;
                        ReadWriteIOUtils.write(binaryValues[j], (OutputStream)stream);
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, dataType));
                }
            }
        }
    }

    public static Tablet deserialize(ByteBuffer byteBuffer) {
        String deviceId = ReadWriteIOUtils.readString(byteBuffer);
        int rowSize = ReadWriteIOUtils.readInt(byteBuffer);
        int schemaSize = 0;
        ArrayList<MeasurementSchema> schemas = new ArrayList<MeasurementSchema>();
        boolean isSchemasNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isSchemasNotNull) {
            schemaSize = ReadWriteIOUtils.readInt(byteBuffer);
            for (int i = 0; i < schemaSize; ++i) {
                boolean hasSchema = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
                if (!hasSchema) continue;
                schemas.add(MeasurementSchema.deserializeFrom(byteBuffer));
            }
        }
        long[] times = new long[rowSize];
        boolean isTimesNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isTimesNotNull) {
            for (int i = 0; i < rowSize; ++i) {
                times[i] = ReadWriteIOUtils.readLong(byteBuffer);
            }
        }
        BitMap[] bitMaps = new BitMap[schemaSize];
        boolean isBitMapsNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isBitMapsNotNull) {
            bitMaps = Tablet.readBitMapsFromBuffer(byteBuffer, schemaSize);
        }
        TSDataType[] dataTypes = (TSDataType[])schemas.stream().map(MeasurementSchema::getType).toArray(TSDataType[]::new);
        Object[] values = new Object[schemaSize];
        boolean isValuesNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
        if (isValuesNotNull) {
            values = Tablet.readTabletValuesFromBuffer(byteBuffer, dataTypes, schemaSize, rowSize);
        }
        Tablet tablet = new Tablet(deviceId, schemas, times, values, bitMaps, rowSize);
        tablet.constructMeasurementIndexMap();
        return tablet;
    }

    public static BitMap[] readBitMapsFromBuffer(ByteBuffer byteBuffer, int columns) {
        BitMap[] bitMaps = new BitMap[columns];
        for (int i = 0; i < columns; ++i) {
            boolean hasBitMap = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
            if (!hasBitMap) continue;
            int size = ReadWriteIOUtils.readInt(byteBuffer);
            Binary valueBinary = ReadWriteIOUtils.readBinary(byteBuffer);
            bitMaps[i] = new BitMap(size, valueBinary.getValues());
        }
        return bitMaps;
    }

    public static Object[] readTabletValuesFromBuffer(ByteBuffer byteBuffer, TSDataType[] types, int columns, int rowSize) {
        Object[] values = new Object[columns];
        block9: for (int i = 0; i < columns; ++i) {
            boolean isValueColumnsNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
            if (!isValueColumnsNotNull) continue;
            switch (types[i]) {
                case BOOLEAN: {
                    boolean[] boolValues = new boolean[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        boolValues[index] = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
                    }
                    values[i] = boolValues;
                    continue block9;
                }
                case INT32: {
                    int[] intValues = new int[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        intValues[index] = ReadWriteIOUtils.readInt(byteBuffer);
                    }
                    values[i] = intValues;
                    continue block9;
                }
                case DATE: {
                    LocalDate[] dateValues = new LocalDate[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        dateValues[index] = DateUtils.parseIntToLocalDate(ReadWriteIOUtils.readInt(byteBuffer));
                    }
                    values[i] = dateValues;
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] longValues = new long[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        longValues[index] = ReadWriteIOUtils.readLong(byteBuffer);
                    }
                    values[i] = longValues;
                    continue block9;
                }
                case FLOAT: {
                    float[] floatValues = new float[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        floatValues[index] = ReadWriteIOUtils.readFloat(byteBuffer);
                    }
                    values[i] = floatValues;
                    continue block9;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        doubleValues[index] = ReadWriteIOUtils.readDouble(byteBuffer);
                    }
                    values[i] = doubleValues;
                    continue block9;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    Binary[] binaryValues = new Binary[rowSize];
                    for (int index = 0; index < rowSize; ++index) {
                        boolean isNotNull = BytesUtils.byteToBool(ReadWriteIOUtils.readByte(byteBuffer));
                        binaryValues[index] = isNotNull ? ReadWriteIOUtils.readBinary(byteBuffer) : Binary.EMPTY_VALUE;
                    }
                    values[i] = binaryValues;
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", types[i]));
                }
            }
        }
        return values;
    }

    public boolean equals(Object o) {
        int columns;
        boolean flag;
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Tablet that = (Tablet)o;
        boolean bl = flag = that.rowSize == this.rowSize && Objects.equals(that.deviceId, this.deviceId) && Objects.equals(that.schemas, this.schemas) && Objects.equals(that.measurementIndex, this.measurementIndex);
        if (!flag) {
            return false;
        }
        int n = columns = this.schemas == null ? 0 : this.schemas.size();
        if (!this.isTimestampsEqual(this.timestamps, that.timestamps, this.rowSize) || !this.isBitMapsEqual(this.bitMaps, that.bitMaps, columns)) {
            return false;
        }
        Object[] thatValues = that.values;
        if (thatValues == this.values) {
            return true;
        }
        if (thatValues == null || this.values == null) {
            return false;
        }
        if (thatValues.length != this.values.length) {
            return false;
        }
        int n2 = this.values.length;
        block9: for (int i = 0; i < n2; ++i) {
            if (thatValues[i] == this.values[i]) continue;
            if (thatValues[i] == null || this.values[i] == null) {
                return false;
            }
            if (!thatValues[i].getClass().equals(this.values[i].getClass())) {
                return false;
            }
            switch (this.schemas.get(i).getType()) {
                case INT32: {
                    int[] thisIntValues = (int[])this.values[i];
                    int[] thatIntValues = (int[])thatValues[i];
                    if (thisIntValues.length < this.rowSize || thatIntValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisIntValues[j] == thatIntValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case DATE: {
                    LocalDate[] thisDateValues = (LocalDate[])this.values[i];
                    LocalDate[] thatDateValues = (LocalDate[])thatValues[i];
                    if (thisDateValues.length < this.rowSize || thatDateValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisDateValues[j].equals(thatDateValues[j])) continue;
                        return false;
                    }
                    continue block9;
                }
                case INT64: 
                case TIMESTAMP: {
                    long[] thisLongValues = (long[])this.values[i];
                    long[] thatLongValues = (long[])thatValues[i];
                    if (thisLongValues.length < this.rowSize || thatLongValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisLongValues[j] == thatLongValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case FLOAT: {
                    float[] thisFloatValues = (float[])this.values[i];
                    float[] thatFloatValues = (float[])thatValues[i];
                    if (thisFloatValues.length < this.rowSize || thatFloatValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisFloatValues[j] == thatFloatValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case DOUBLE: {
                    double[] thisDoubleValues = (double[])this.values[i];
                    double[] thatDoubleValues = (double[])thatValues[i];
                    if (thisDoubleValues.length < this.rowSize || thatDoubleValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisDoubleValues[j] == thatDoubleValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case BOOLEAN: {
                    boolean[] thisBooleanValues = (boolean[])this.values[i];
                    boolean[] thatBooleanValues = (boolean[])thatValues[i];
                    if (thisBooleanValues.length < this.rowSize || thatBooleanValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisBooleanValues[j] == thatBooleanValues[j]) continue;
                        return false;
                    }
                    continue block9;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    Binary[] thisBinaryValues = (Binary[])this.values[i];
                    Binary[] thatBinaryValues = (Binary[])thatValues[i];
                    if (thisBinaryValues.length < this.rowSize || thatBinaryValues.length < this.rowSize) {
                        return false;
                    }
                    for (int j = 0; j < this.rowSize; ++j) {
                        if (thisBinaryValues[j].equals((Object)thatBinaryValues[j])) continue;
                        return false;
                    }
                    continue block9;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format(NOT_SUPPORT_DATATYPE, this.schemas.get(i).getType()));
                }
            }
        }
        return true;
    }

    private boolean isTimestampsEqual(long[] thisTimestamps, long[] thatTimestamps, int rowSize) {
        if (thisTimestamps == thatTimestamps) {
            return true;
        }
        if (thisTimestamps == null || thatTimestamps == null) {
            return false;
        }
        for (int i = 0; i < rowSize; ++i) {
            if (thisTimestamps[i] == thatTimestamps[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isBitMapsEqual(BitMap[] thisBitMaps, BitMap[] thatBitMaps, int columns) {
        if (thisBitMaps == thatBitMaps) {
            return true;
        }
        if (thisBitMaps == null) {
            for (int i = 0; i < columns; ++i) {
                if (thatBitMaps[i] == null || thatBitMaps[i].isAllMarked()) continue;
                return false;
            }
            return true;
        }
        if (thatBitMaps == null) {
            for (int i = 0; i < columns; ++i) {
                if (thisBitMaps[i] == null || thisBitMaps[i].isAllMarked()) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < columns; ++i) {
            if (thisBitMaps[i].equals((Object)thatBitMaps[i])) continue;
            return false;
        }
        return true;
    }
}

