/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.drepair.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.iotdb.library.drepair.util.ValueFill;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.access.RowIterator;

public class ScreenFill
extends ValueFill {
    private double smin;
    private double smax;
    private double w;

    public ScreenFill(RowIterator dataIterator) throws Exception {
        super(dataIterator);
        this.setParameters();
    }

    @Override
    public void fill() {
        ArrayList<Pair<Long, Double>> ans = new ArrayList<Pair<Long, Double>>();
        int currentIndex = 0;
        while (currentIndex < this.n) {
            ans.add(Pair.of(this.time[currentIndex], this.original[currentIndex]));
            if (Double.isNaN(this.original[currentIndex])) {
                int startIndex = currentIndex;
                long fillTime = this.time[currentIndex];
                int nextIndex = -1;
                ++currentIndex;
                while (currentIndex < this.n && (double)fillTime + this.w >= (double)this.time[currentIndex]) {
                    ans.add(Pair.of(this.time[currentIndex], this.original[currentIndex]));
                    if (Double.isNaN(this.original[currentIndex]) && nextIndex == -1) {
                        nextIndex = currentIndex;
                    }
                    ++currentIndex;
                }
                this.local(ans, startIndex);
                if (nextIndex <= 0) continue;
                while (currentIndex > nextIndex) {
                    ans.remove(currentIndex - 1);
                    --currentIndex;
                }
                continue;
            }
            ++currentIndex;
        }
        int k = 0;
        for (Pair pair : ans) {
            this.repaired[k] = (Double)pair.getRight();
            ++k;
        }
    }

    private double getMedian(ArrayList<Pair<Long, Double>> list, int index) {
        int m4 = 0;
        while (index + m4 + 1 < list.size() && (double)list.get(index + m4 + 1).getLeft().longValue() <= (double)list.get(index).getLeft().longValue() + this.w) {
            ++m4;
        }
        int count = 0;
        for (int i = 1; i <= m4; ++i) {
            if (Double.isNaN(list.get(index + i).getRight())) continue;
            ++count;
        }
        double[] x = new double[2 * count];
        int tempCount = 0;
        for (int i = 1; i <= m4; ++i) {
            if (Double.isNaN(list.get(index + i).getRight())) continue;
            x[tempCount] = list.get(index + i).getRight() + this.smin * (double)(list.get(index).getLeft() - list.get(index + i).getLeft());
            x[tempCount + count] = list.get(index + i).getRight() + this.smax * (double)(list.get(index).getLeft() - list.get(index + i).getLeft());
            ++tempCount;
        }
        Arrays.sort(x);
        return x[count];
    }

    private double getRepairedValue(ArrayList<Pair<Long, Double>> list, int index, double mid) {
        double xmin = list.get(index - 1).getRight() + this.smin * (double)(list.get(index).getLeft() - list.get(index - 1).getLeft());
        double xmax = list.get(index - 1).getRight() + this.smax * (double)(list.get(index).getLeft() - list.get(index - 1).getLeft());
        double temp = mid;
        temp = Math.min(xmax, temp);
        temp = Math.max(xmin, temp);
        return temp;
    }

    private void local(ArrayList<Pair<Long, Double>> list, int index) {
        double mid = this.getMedian(list, index);
        if (index == 0) {
            list.set(index, Pair.of(list.get(index).getLeft(), mid));
        } else {
            double temp = this.getRepairedValue(list, index, mid);
            list.set(index, Pair.of(list.get(index).getLeft(), temp));
        }
    }

    private void setParameters() {
        double[] speed = Util.speed(this.original, this.time);
        Median median = new Median();
        double mid = median.evaluate(speed);
        double sigma = Util.mad(speed);
        this.smax = mid + 3.0 * sigma;
        this.smin = mid - 3.0 * sigma;
        double[] interval = Util.variation(this.time);
        this.w = 5.0 * median.evaluate(interval);
    }
}

