/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.transport;

import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DomainSocketAddressUtils {
    public static boolean isDomainSocketAddress(SocketAddress socketAddress) {
        return socketAddress instanceof DomainSocketAddress || socketAddress instanceof UnixDomainSocketAddress;
    }

    public static String path(SocketAddress socketAddress) {
        if (socketAddress instanceof DomainSocketAddress) {
            return ((DomainSocketAddress)socketAddress).path();
        }
        if (socketAddress instanceof UnixDomainSocketAddress) {
            return ((UnixDomainSocketAddress)socketAddress).getPath().toString();
        }
        throw new IllegalArgumentException(String.valueOf(socketAddress) + " not supported");
    }

    private DomainSocketAddressUtils() {
    }
}

