/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Optional;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.server.nodes.filters.AttributeFilters;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;

public class VendorServerInfoNodes {
    public static void add(UaNodeContext context) {
        VendorServerInfoNodes.addVendorServerInfoNodes(context);
    }

    private static void addVendorServerInfoNodes(UaNodeContext context) {
        Optional<UaNode> maybeVendorServerInfo = context.getServer().getAddressSpaceManager().getManagedNode(Identifiers.Server_VendorServerInfo);
        maybeVendorServerInfo.ifPresent(node -> {
            UaObjectNode vendorServerInfo = (UaObjectNode)node;
            VendorServerInfoNodes.addVendorInfoPlainJava(context, vendorServerInfo);
            VendorServerInfoNodes.addVendorInfoJmx(context, vendorServerInfo);
            VendorServerInfoNodes.addVendorInfoSunJmx(context, vendorServerInfo);
        });
    }

    private static void addVendorInfoPlainJava(UaNodeContext context, UaObjectNode vendorServerInfo) {
        UaVariableNode availableProcessors = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/AvailableProcessors")).setBrowseName(new QualifiedName(1, "AvailableProcessors")).setDisplayName(LocalizedText.english((String)"AvailableProcessors")).setDataType(Identifiers.Int32).buildAndAdd();
        availableProcessors.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)Runtime.getRuntime().availableProcessors()))));
        vendorServerInfo.addComponent(availableProcessors);
    }

    private static void addVendorInfoJmx(UaNodeContext context, UaObjectNode vendorServerInfo) {
        java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        UaVariableNode usedMemory = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/UsedMemory")).setBrowseName(new QualifiedName(1, "UsedMemory")).setDisplayName(LocalizedText.english((String)"UsedMemory")).setDataType(Identifiers.Int64).buildAndAdd();
        usedMemory.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)memoryBean.getHeapMemoryUsage().getUsed()))));
        UaVariableNode maxMemory = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/MaxMemory")).setBrowseName(new QualifiedName(1, "MaxMemory")).setDisplayName(LocalizedText.english((String)"MaxMemory")).setDataType(Identifiers.Int64).buildAndAdd();
        maxMemory.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)memoryBean.getHeapMemoryUsage().getMax()))));
        UaVariableNode osName = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/OsName")).setBrowseName(new QualifiedName(1, "OsName")).setDisplayName(LocalizedText.english((String)"OsName")).setDataType(Identifiers.String).buildAndAdd();
        osName.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)osBean.getName()))));
        UaVariableNode osArch = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/OsArch")).setBrowseName(new QualifiedName(1, "OsArch")).setDisplayName(LocalizedText.english((String)"OsArch")).setDataType(Identifiers.String).buildAndAdd();
        osArch.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)osBean.getArch()))));
        UaVariableNode osVersion = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/OsVersion")).setBrowseName(new QualifiedName(1, "OsVersion")).setDisplayName(LocalizedText.english((String)"OsVersion")).setDataType(Identifiers.String).buildAndAdd();
        osVersion.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)osBean.getVersion()))));
        vendorServerInfo.addComponent(usedMemory);
        vendorServerInfo.addComponent(maxMemory);
        vendorServerInfo.addComponent(osName);
        vendorServerInfo.addComponent(osArch);
        vendorServerInfo.addComponent(osVersion);
    }

    private static void addVendorInfoSunJmx(UaNodeContext context, UaObjectNode vendorServerInfo) {
        java.lang.management.OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        if (osMxBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsMxBean = (OperatingSystemMXBean)osMxBean;
            UaVariableNode processCpuLoad = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/ProcessCpuLoad")).setBrowseName(new QualifiedName(1, "ProcessCpuLoad")).setDisplayName(LocalizedText.english((String)"ProcessCpuLoad")).setDataType(Identifiers.Double).buildAndAdd();
            processCpuLoad.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)(sunOsMxBean.getProcessCpuLoad() * 100.0)))));
            UaVariableNode systemCpuLoad = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/SystemCpuLoad")).setBrowseName(new QualifiedName(1, "SystemCpuLoad")).setDisplayName(LocalizedText.english((String)"SystemCpuLoad")).setDataType(Identifiers.Double).buildAndAdd();
            systemCpuLoad.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)(sunOsMxBean.getSystemCpuLoad() * 100.0)))));
            vendorServerInfo.addComponent(processCpuLoad);
            vendorServerInfo.addComponent(systemCpuLoad);
            if (sunOsMxBean instanceof UnixOperatingSystemMXBean) {
                UnixOperatingSystemMXBean unixBean = (UnixOperatingSystemMXBean)sunOsMxBean;
                UaVariableNode openFileDescriptors = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/OpenFileDescriptors")).setBrowseName(new QualifiedName(1, "OpenFileDescriptors")).setDisplayName(LocalizedText.english((String)"OpenFileDescriptors")).setDataType(Identifiers.Int64).buildAndAdd();
                openFileDescriptors.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)unixBean.getOpenFileDescriptorCount()))));
                UaVariableNode maxFileDescriptors = UaVariableNode.builder(context).setNodeId(new NodeId(1, "VendorServerInfo/MaxFileDescriptors")).setBrowseName(new QualifiedName(1, "MaxFileDescriptors")).setDisplayName(LocalizedText.english((String)"MaxFileDescriptors")).setDataType(Identifiers.Int64).buildAndAdd();
                maxFileDescriptors.getFilterChain().addLast(AttributeFilters.getValue(ctx -> new DataValue(new Variant((Object)unixBean.getMaxFileDescriptorCount()))));
                vendorServerInfo.addComponent(openFileDescriptors);
                vendorServerInfo.addComponent(maxFileDescriptors);
            }
        }
    }
}

