/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule.Util;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableFunctionProcessorNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class PruneTableFunctionProcessorSourceColumns
implements Rule<TableFunctionProcessorNode> {
    private static final Pattern<TableFunctionProcessorNode> PATTERN = Patterns.tableFunctionProcessor();

    @Override
    public Pattern<TableFunctionProcessorNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionProcessorNode node, Captures captures, Rule.Context context) {
        if (node.getChildren().isEmpty() || !node.getPassThroughSpecification().isPresent()) {
            return Rule.Result.empty();
        }
        ImmutableSet.Builder requiredInputs = ImmutableSet.builder();
        for (TableFunctionNode.PassThroughColumn column : node.getPassThroughSpecification().get().getColumns()) {
            requiredInputs.add((Object)column.getSymbol());
        }
        node.getRequiredSymbols().forEach(arg_0 -> ((ImmutableSet.Builder)requiredInputs).add(arg_0));
        node.getDataOrganizationSpecification().ifPresent(specification -> {
            requiredInputs.addAll(specification.getPartitionBy());
            specification.getOrderingScheme().ifPresent(orderingScheme -> requiredInputs.addAll(orderingScheme.getOrderBy()));
        });
        return Util.restrictOutputs(context.getIdAllocator(), node.getChild(), (Set<Symbol>)requiredInputs.build()).map(child -> Rule.Result.ofPlanNode(new TableFunctionProcessorNode(node.getPlanNodeId(), node.getName(), node.getProperOutputs(), Optional.of(child), node.getPassThroughSpecification(), node.getRequiredSymbols(), node.getDataOrganizationSpecification(), node.isRowSemantic(), node.getTableFunctionHandle(), node.isRequireRecordSnapshot()))).orElse(Rule.Result.empty());
    }
}

