/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.LoggerNameListener;

class LogPanelLoggerTreeModel
extends DefaultTreeModel
implements LoggerNameListener {
    private Map<String, LogPanelTreeNode> fullPackageMap = new HashMap<String, LogPanelTreeNode>();
    private final Logger logger = LogManager.getLogger(LogPanelLoggerTreeModel.class);

    LogPanelLoggerTreeModel() {
        super(new LogPanelTreeNode("Root Logger"));
    }

    @Override
    public void loggerNameAdded(String loggerName) {
        SwingUtilities.invokeLater(() -> this.addLoggerNameInDispatchThread(loggerName));
    }

    @Override
    public void reset() {
        DefaultMutableTreeNode current = (DefaultMutableTreeNode)this.getRoot();
        current.removeAllChildren();
        this.fullPackageMap.clear();
        this.nodeStructureChanged(current);
    }

    private void addLoggerNameInDispatchThread(String loggerName) {
        String[] packages = this.tokenize(loggerName);
        DefaultMutableTreeNode current = (DefaultMutableTreeNode)this.getRoot();
        block0: for (int i = 0; i < packages.length; ++i) {
            String packageName = packages[i];
            Enumeration<TreeNode> enumeration = current.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
                String childName = child.getUserObject().toString();
                if (!childName.equals(packageName)) continue;
                current = child;
                continue block0;
            }
            LogPanelTreeNode newChild = new LogPanelTreeNode(packageName);
            StringBuilder fullPackageBuf = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                fullPackageBuf.append(packages[j]);
                if (j >= i) continue;
                fullPackageBuf.append(".");
            }
            this.logger.debug((Object)("Adding to Map " + fullPackageBuf.toString()));
            this.fullPackageMap.put(fullPackageBuf.toString(), newChild);
            DefaultMutableTreeNode changedNode = current;
            changedNode.add(newChild);
            int[] changedIndices = new int[changedNode.getChildCount()];
            for (int j = 0; j < changedIndices.length; ++j) {
                changedIndices[j] = j;
            }
            this.nodesWereInserted(changedNode, new int[]{changedNode.getIndex(newChild)});
            this.nodesChanged(changedNode, changedIndices);
            current = newChild;
        }
    }

    LogPanelTreeNode lookupLogger(String newLogger) {
        if (this.fullPackageMap.containsKey(newLogger)) {
            return this.fullPackageMap.get(newLogger);
        }
        this.logger.debug((Object)("No logger found matching '" + newLogger + "'"));
        this.logger.debug((Object)("Map Dump: " + this.fullPackageMap));
        return null;
    }

    private String[] tokenize(String loggerName) {
        StringTokenizer tok = new StringTokenizer(loggerName, ".");
        String[] tokens = new String[tok.countTokens()];
        int index = 0;
        while (tok.hasMoreTokens()) {
            tokens[index++] = tok.nextToken();
        }
        return tokens;
    }

    private static class LogPanelTreeNode
    extends DefaultMutableTreeNode {
        protected static Comparator nodeComparator = (o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString());

        private LogPanelTreeNode(String logName) {
            super(logName);
        }

        @Override
        public void insert(MutableTreeNode newChild, int childIndex) {
            super.insert(newChild, childIndex);
            this.children.sort(nodeComparator);
        }
    }
}

