/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.openjpa.persistence.jest.AbstractCommand;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.ObjectFormatter;
import org.apache.openjpa.persistence.jest.ProcessingException;

class DomainCommand
extends AbstractCommand {
    private static final List<String> _validQualifiers = Arrays.asList("format");

    public DomainCommand(JPAServletContext ctx) {
        super(ctx);
    }

    @Override
    protected Collection<String> getValidQualifiers() {
        return _validQualifiers;
    }

    @Override
    protected int getMaximumArguments() {
        return 0;
    }

    public String getAction() {
        return "domain";
    }

    @Override
    public void process() throws ProcessingException, IOException {
        JPAServletContext ctx = this.getExecutionContext();
        ObjectFormatter<?> formatter = this.getObjectFormatter();
        ctx.getResponse().setContentType(formatter.getMimeType());
        formatter.writeOut(ctx.getPersistenceContext().getMetamodel(), _loc.get("domain-title").toString(), _loc.get("domain-desc").toString(), ctx.getRequestURI(), (OutputStream)ctx.getResponse().getOutputStream());
    }
}

