/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.Normalizer;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.BooleanRepresentationFactory;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.jdbc.DelegatingConnection;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.apache.openjpa.lib.jdbc.ReportingSQLException;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StoreException;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class PostgresDictionary
extends DBDictionary {
    private static final Localizer _loc = Localizer.forPackage(PostgresDictionary.class);
    private static Constructor<PostgresConnection> postgresConnectionImpl;
    private static Constructor<PostgresPreparedStatement> postgresPreparedStatementImpl;
    private Method dbcpGetDelegate;
    private Method connectionUnwrap;
    protected Set<String> _timestampTypes = new HashSet<String>();
    public String allSequencesSQL = "SELECT NULL AS SEQUENCE_SCHEMA, relname AS SEQUENCE_NAME FROM pg_class WHERE relkind='S'";
    public String namedSequencesFromAllSchemasSQL = "SELECT NULL AS SEQUENCE_SCHEMA, relname AS SEQUENCE_NAME FROM pg_class WHERE relkind='S' AND relname = ?";
    public String allSequencesFromOneSchemaSQL = "SELECT NULL AS SEQUENCE_SCHEMA, relname AS SEQUENCE_NAME FROM pg_class, pg_namespace WHERE relkind='S' AND pg_class.relnamespace = pg_namespace.oid AND nspname = ?";
    public String namedSequenceFromOneSchemaSQL = "SELECT NULL AS SEQUENCE_SCHEMA, relname AS SEQUENCE_NAME FROM pg_class, pg_namespace WHERE relkind='S' AND pg_class.relnamespace = pg_namespace.oid AND relname = ? AND nspname = ?";
    public boolean supportsSetFetchSize = true;
    public String isOwnedSequenceSQL = "SELECT pg_get_serial_sequence(?, ?)";

    public PostgresDictionary() {
        this.platform = "PostgreSQL";
        this.validationSQL = "SELECT NOW()";
        this.datePrecision = 1000;
        this.supportsAlterTableWithDropColumn = false;
        this.supportsDeferredConstraints = true;
        this.supportsSelectStartIndex = true;
        this.supportsSelectEndIndex = true;
        this.maxTableNameLength = 63;
        this.maxColumnNameLength = 63;
        this.maxIndexNameLength = 63;
        this.maxConstraintNameLength = 63;
        this.maxAutoAssignNameLength = 63;
        this.schemaCase = "lower";
        this.rangePosition = 3;
        this.requiresAliasForSubselect = true;
        this.allowsAliasInBulkClause = false;
        this.lastGeneratedKeyQuery = "SELECT CURRVAL(''{1}_{0}_seq'')";
        this.supportsAutoAssign = true;
        this.autoAssignTypeName = "BIGSERIAL";
        this.nextSequenceQuery = "SELECT NEXTVAL(''{0}'')";
        this.useGetBytesForBlobs = true;
        this.useSetBytesForBlobs = true;
        this.useGetStringForClobs = true;
        this.useSetStringForClobs = true;
        this.bitTypeName = "BOOL";
        this.smallintTypeName = "SMALLINT";
        this.realTypeName = "FLOAT4";
        this.tinyintTypeName = "SMALLINT";
        this.binaryTypeName = "BYTEA";
        this.blobTypeName = "BYTEA";
        this.longVarbinaryTypeName = "BYTEA";
        this.varbinaryTypeName = "BYTEA";
        this.clobTypeName = "TEXT";
        this.longVarcharTypeName = "TEXT";
        this.doubleTypeName = "DOUBLE PRECISION";
        this.timestampTypeName = "TIMESTAMP";
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("BOOL", "BYTEA", "NAME", "INT8", "INT2", "INT2VECTOR", "INT4", "REGPROC", "TEXT", "OID", "TID", "XID", "CID", "OIDVECTOR", "SET", "FLOAT4", "FLOAT8", "ABSTIME", "RELTIME", "TINTERVAL", "MONEY"));
        this.booleanRepresentation = BooleanRepresentationFactory.BOOLEAN;
        this.supportsLockingWithDistinctClause = false;
        this.supportsQueryTimeout = false;
        this.supportsLockingWithOuterJoin = false;
        this.reservedWordSet.addAll(Arrays.asList("ABORT", "ACL", "AGGREGATE", "APPEND", "ARCHIVE", "ARCH_STORE", "BACKWARD", "BINARY", "CHANGE", "CLUSTER", "COPY", "DATABASE", "DELIMITER", "DELIMITERS", "DO", "EXPLAIN", "EXTEND", "FORWARD", "HEAVY", "INDEX", "INHERITS", "ISNULL", "LIGHT", "LISTEN", "LOAD", "MERGE", "NOTHING", "NOTIFY", "NOTNULL", "OID", "OIDS", "PURGE", "RECIPE", "RENAME", "REPLACE", "RETRIEVE", "RETURNS", "RULE", "SETOF", "STDIN", "STDOUT", "STORE", "VACUUM", "VERBOSE", "VERSION"));
        this.invalidColumnWordSet.addAll(Arrays.asList("ALL", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BETWEEN", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "END", "EXCEPT", "FALSE", "FOR", "FOREIGN", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "NATURAL", "NOT", "NOTNULL", "NULL", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVERLAPS", "PRIMARY", "REFERENCES", "RIGHT", "SELECT", "SESSION_USER", "SOME", "TABLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VERBOSE", "WHEN", "WHERE"));
        this._timestampTypes.add("ABSTIME");
        this._timestampTypes.add("TIMESTAMP");
        this._timestampTypes.add(this.timestampTypeName.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public Date getDate(ResultSet rs, int column) throws SQLException {
        try {
            return super.getDate(rs, column);
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            String dateStr = rs.getString(column);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SS");
            try {
                return fmt.parse(dateStr);
            }
            catch (ParseException pe) {
                throw new SQLException(pe.toString());
            }
        }
    }

    @Override
    public byte getByte(ResultSet rs, int column) throws SQLException {
        try {
            return super.getByte(rs, column);
        }
        catch (SQLException sqle) {
            return super.getBigDecimal(rs, column).byteValue();
        }
    }

    @Override
    public short getShort(ResultSet rs, int column) throws SQLException {
        try {
            return super.getShort(rs, column);
        }
        catch (SQLException sqle) {
            return super.getBigDecimal(rs, column).shortValue();
        }
    }

    @Override
    public int getInt(ResultSet rs, int column) throws SQLException {
        try {
            return super.getInt(rs, column);
        }
        catch (SQLException sqle) {
            return super.getBigDecimal(rs, column).intValue();
        }
    }

    @Override
    public long getLong(ResultSet rs, int column) throws SQLException {
        try {
            return super.getLong(rs, column);
        }
        catch (SQLException sqle) {
            return super.getBigDecimal(rs, column).longValue();
        }
    }

    @Override
    public void setNull(PreparedStatement stmnt, int idx, int colType, Column col) throws SQLException {
        if (col != null && col.isXML()) {
            stmnt.setNull(idx, 1111);
            return;
        }
        if (colType == 2004) {
            colType = -2;
        }
        stmnt.setNull(idx, colType);
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (end != Long.MAX_VALUE) {
            buf.append(" LIMIT ").appendValue(end - start);
        }
        if (start != 0L) {
            buf.append(" OFFSET ").appendValue(start);
        }
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("(POSITION(");
        find.appendTo(buf);
        buf.append(" IN ");
        if (start != null) {
            this.substring(buf, str, start, null);
        } else {
            str.appendTo(buf);
        }
        buf.append(")");
        if (start != null) {
            buf.append(" - 1 + ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    @Override
    protected boolean supportsDeferredUniqueConstraints() {
        return false;
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        if (DBIdentifier.isNull(schemaName) && DBIdentifier.isNull(sequenceName)) {
            return this.allSequencesSQL;
        }
        if (DBIdentifier.isNull(schemaName)) {
            return this.namedSequencesFromAllSchemasSQL;
        }
        if (DBIdentifier.isNull(sequenceName)) {
            return this.allSequencesFromOneSchemaSQL;
        }
        return this.namedSequenceFromOneSchemaSQL;
    }

    @Override
    public boolean isSystemSequence(String name, String schema, boolean targetSchema) {
        return this.isSystemSequence(DBIdentifier.newTable(name), DBIdentifier.newSchema(schema), targetSchema);
    }

    @Override
    public boolean isSystemSequence(DBIdentifier name, DBIdentifier schema, boolean targetSchema) {
        return this.isSystemSequence(name, schema, targetSchema, null);
    }

    @Override
    public boolean isSystemSequence(DBIdentifier name, DBIdentifier schema, boolean targetSchema, Connection conn) {
        if (super.isSystemSequence(name, schema, targetSchema)) {
            return true;
        }
        return this.isOwnedSequence(name, schema, conn);
    }

    public boolean isOwnedSequence(DBIdentifier name, DBIdentifier schema, Connection conn) {
        String strName;
        String string = strName = DBIdentifier.isNull(name) ? "" : name.getName();
        if (strName == null || !strName.toUpperCase(Locale.ENGLISH).endsWith("_SEQ")) {
            return false;
        }
        if (conn == null) {
            return this.isOwnedSequence(strName);
        }
        String[][] namePairs = this.buildNames(strName);
        if (namePairs != null) {
            try {
                for (int i = 0; i < namePairs.length; ++i) {
                    if (!this.queryOwnership(conn, namePairs[i], schema)) continue;
                    return true;
                }
            }
            catch (Throwable t) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn(_loc.get("psql-owned-seq-warning"), t);
                }
                return this.isOwnedSequence(strName);
            }
        } else {
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Unable to query ownership for sequence %s using the connection. Falling back to simpler detection based on the name", name.getName()));
            }
            return this.isOwnedSequence(strName);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    private boolean queryOwnership(Connection conn, String[] namePair, DBIdentifier schema) throws Throwable {
        boolean t22222222222222222222;
        ResultSet rs;
        PreparedStatement ps;
        block39: {
            block37: {
                boolean t22222222222222222222;
                block38: {
                    block35: {
                        boolean bl;
                        block36: {
                            ps = null;
                            rs = null;
                            ps = this.prepareStatement(conn, this.isOwnedSequenceSQL);
                            String tblName = "";
                            if (!DBIdentifier.isEmpty(schema)) {
                                tblName = schema.getName() + this.getIdentifierDelimiter();
                            }
                            tblName = tblName + namePair[0];
                            ps.setString(1, tblName);
                            String colName = this.toDBName(DBIdentifier.newColumn(namePair[1]));
                            ps.setString(2, colName);
                            ps.execute();
                            rs = ps.getResultSet();
                            if (rs != null && rs.next()) break block35;
                            bl = false;
                            if (rs == null) break block36;
                            try {
                                rs.close();
                            }
                            catch (Throwable t3) {
                                // empty catch block
                            }
                        }
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable t22222222222222222222) {
                                // empty catch block
                            }
                        }
                        return bl;
                    }
                    String val = this.getString(rs, 1);
                    if (val != null && val.length() != 0) break block37;
                    t22222222222222222222 = false;
                    if (rs == null) break block38;
                    try {
                        rs.close();
                    }
                    catch (Throwable t4) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t5) {
                        // empty catch block
                    }
                }
                return t22222222222222222222;
            }
            t22222222222222222222 = true;
            if (rs == null) break block39;
            try {
                rs.close();
            }
            catch (Throwable t6) {
                // empty catch block
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Throwable t7) {
                // empty catch block
            }
        }
        return t22222222222222222222;
        catch (Throwable t8) {
            ReportingSQLException rse;
            if (t8 instanceof ReportingSQLException && ("42P01".equals((rse = (ReportingSQLException)t8).getSQLState()) || "42703".equals(rse.getSQLState()))) {
                boolean bl = false;
                return bl;
            }
            throw t8;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        {
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t9) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Throwable t10) {}
                }
            }
        }
    }

    private String[][] buildNames(String strName) {
        String[] parts = Normalizer.splitName(strName, "_");
        if (parts == null || parts.length < 3) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Unable to parse sequences from %s. Found %s parts. Returning null", strName, parts == null ? 0 : parts.length));
            }
            return null;
        }
        if (parts.length == 3) {
            return new String[][]{{parts[0], parts[1]}};
        }
        String[][] names = new String[parts.length - 2][2];
        for (int i = 0; i < parts.length - 2; ++i) {
            String[] namePair = new String[2];
            StringBuilder name0 = new StringBuilder();
            StringBuilder name1 = new StringBuilder();
            for (int j = 0; j < parts.length - 1; ++j) {
                if (j <= i) {
                    name0.append(parts[j]);
                    if (j >= i) continue;
                    name0.append("_");
                    continue;
                }
                name1.append(parts[j]);
                if (j >= parts.length - 2) continue;
                name1.append("_");
            }
            namePair[0] = name0.toString();
            namePair[1] = name1.toString();
            names[i] = namePair;
        }
        return names;
    }

    private boolean isOwnedSequence(String strName) {
        int idx = strName == null ? -1 : strName.indexOf(95);
        return idx != -1 && idx != strName.length() - 4 && strName.toUpperCase(Locale.ENGLISH).endsWith("_SEQ");
    }

    @Override
    public boolean isSystemTable(String name, String schema, boolean targetSchema) {
        return this.isSystemTable(DBIdentifier.newTable(name), DBIdentifier.newSchema(schema), targetSchema);
    }

    @Override
    public boolean isSystemTable(DBIdentifier name, DBIdentifier schema, boolean targetSchema) {
        String strName = DBIdentifier.isNull(name) ? null : name.getName();
        return super.isSystemTable(name, schema, targetSchema) || strName != null && strName.toLowerCase(Locale.ENGLISH).startsWith("pg_");
    }

    @Override
    public boolean isSystemIndex(String name, Table table) {
        return this.isSystemIndex(DBIdentifier.newIndex(name), table);
    }

    @Override
    public boolean isSystemIndex(DBIdentifier name, Table table) {
        String strName = DBIdentifier.isNull(name) ? null : name.getName();
        return super.isSystemIndex(name, table) || strName != null && strName.toLowerCase(Locale.ENGLISH).startsWith("pg_");
    }

    @Override
    public Connection decorate(Connection conn) throws SQLException {
        return ConcreteClassGenerator.newInstance(postgresConnectionImpl, super.decorate(conn), this);
    }

    @Override
    public InputStream getLOBStream(JDBCStore store, ResultSet rs, int column) throws SQLException {
        DelegatingConnection conn = (DelegatingConnection)store.getConnection();
        conn.setAutoCommit(false);
        LargeObjectManager lom = this.getLargeObjectManager(conn);
        if (rs.getInt(column) != -1) {
            LargeObject lo = lom.open(rs.getInt(column));
            return lo.getInputStream();
        }
        return null;
    }

    @Override
    public void insertBlobForStreamingLoad(Row row, Column col, JDBCStore store, Object ob, Select sel) throws SQLException {
        if (row.getAction() == 1) {
            this.insertPostgresBlob(row, col, store, ob);
        } else if (row.getAction() == 0) {
            this.updatePostgresBlob(row, col, store, ob, sel);
        }
    }

    private void insertPostgresBlob(Row row, Column col, JDBCStore store, Object ob) throws SQLException {
        if (ob != null) {
            col.setType(4);
            DelegatingConnection conn = (DelegatingConnection)store.getConnection();
            try {
                conn.setAutoCommit(false);
                LargeObjectManager lom = this.getLargeObjectManager(conn);
                int oid = lom.create();
                LargeObject lo = lom.open(oid, 131072);
                OutputStream os = lo.getOutputStream();
                this.copy((InputStream)ob, os);
                lo.close();
                row.setInt(col, oid);
            }
            catch (IOException ioe) {
                throw new StoreException(ioe);
            }
            finally {
                conn.close();
            }
        } else {
            row.setInt(col, -1);
        }
    }

    private void updatePostgresBlob(Row row, Column col, JDBCStore store, Object ob, Select sel) throws SQLException {
        JDBCFetchConfiguration fetch = store.getFetchConfiguration();
        SQLBuffer sql2 = sel.toSelect(true, fetch);
        ResultSet res = null;
        DelegatingConnection conn = (DelegatingConnection)store.getConnection();
        PreparedStatement stmnt = null;
        try {
            stmnt = sql2.prepareStatement(conn, fetch, 1005, 1008);
            this.setTimeouts(stmnt, fetch, true);
            res = stmnt.executeQuery();
            if (!res.next()) {
                throw new InternalException(_loc.get("stream-exception"));
            }
            int oid = res.getInt(1);
            if (oid != -1) {
                conn.setAutoCommit(false);
                LargeObjectManager lom = this.getLargeObjectManager(conn);
                if (ob != null) {
                    LargeObject lo = lom.open(oid, 131072);
                    OutputStream os = lo.getOutputStream();
                    long size = this.copy((InputStream)ob, os);
                    lo.truncate((int)size);
                    lo.close();
                } else {
                    lom.delete(oid);
                    row.setInt(col, -1);
                }
            } else if (ob != null) {
                conn.setAutoCommit(false);
                LargeObjectManager lom = this.getLargeObjectManager(conn);
                oid = lom.create();
                LargeObject lo = lom.open(oid, 131072);
                OutputStream os = lo.getOutputStream();
                this.copy((InputStream)ob, os);
                lo.close();
                row.setInt(col, oid);
            }
        }
        catch (IOException ioe) {
            throw new StoreException(ioe);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void updateBlob(Select sel, JDBCStore store, InputStream is) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStream(JDBCStore store, Select sel) throws SQLException {
        JDBCFetchConfiguration fetch = store.getFetchConfiguration();
        SQLBuffer sql2 = sel.toSelect(true, fetch);
        ResultSet res = null;
        DelegatingConnection conn = (DelegatingConnection)store.getConnection();
        PreparedStatement stmnt = null;
        try {
            stmnt = sql2.prepareStatement(conn, fetch, 1005, 1008);
            this.setTimeouts(stmnt, fetch, true);
            res = stmnt.executeQuery();
            if (!res.next()) {
                throw new InternalException(_loc.get("stream-exception"));
            }
            int oid = res.getInt(1);
            if (oid != -1) {
                conn.setAutoCommit(false);
                LargeObjectManager lom = this.getLargeObjectManager(conn);
                lom.delete(oid);
            }
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (SQLException e) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        int min;
        int maj;
        block6: {
            super.connectedConfiguration(conn);
            DatabaseMetaData metaData = conn.getMetaData();
            maj = 0;
            min = 0;
            if (this.isJDBC3) {
                maj = metaData.getDatabaseMajorVersion();
                min = metaData.getDatabaseMinorVersion();
            } else {
                try {
                    String productVersion = metaData.getDatabaseProductVersion();
                    String[] majMin = productVersion.split("\\.");
                    maj = Integer.parseInt(majMin[0]);
                    min = Integer.parseInt(majMin[1]);
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) break block6;
                    this.log.warn(e.toString(), e);
                }
            }
        }
        if (maj >= 9 || maj == 8 && min >= 3) {
            this.supportsXMLColumn = true;
        }
        if (maj <= 8 || maj == 9 && min == 0) {
            this.requiresSearchStringEscapeForLike = true;
            this.searchStringEscape = "\\\\";
        }
    }

    @Override
    public void setClobString(PreparedStatement stmnt, int idx, String val, Column col) throws SQLException {
        if (col != null && col.isXML()) {
            stmnt.setObject(idx, (Object)val, 1111);
        } else {
            super.setClobString(stmnt, idx, val, col);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int column, Map map) throws SQLException {
        Object obj = super.getObject(rs, column, map);
        if (obj == null) {
            return null;
        }
        if (obj.getClass().getName().equals("org.postgresql.util.PGobject")) {
            try {
                Method m = obj.getClass().getMethod("getType", null);
                Object type = m.invoke(obj, (Object[])null);
                if (this._timestampTypes.contains(((String)type).toUpperCase(Locale.ENGLISH))) {
                    return rs.getTimestamp(column);
                }
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                throw new SQLException(t.getMessage());
            }
        }
        return obj;
    }

    @Override
    public void appendXmlComparison(SQLBuffer buf, String op, FilterValue lhs, FilterValue rhs, boolean lhsxml, boolean rhsxml) {
        super.appendXmlComparison(buf, op, lhs, rhs, lhsxml, rhsxml);
        if (lhsxml) {
            this.appendXmlValue(buf, lhs);
        } else {
            lhs.appendTo(buf);
        }
        buf.append(" ").append(op).append(" ");
        if (rhsxml) {
            this.appendXmlValue(buf, rhs);
        } else {
            rhs.appendTo(buf);
        }
    }

    private void appendXmlValue(SQLBuffer buf, FilterValue val) {
        Class<?> rc = Filters.wrap(val.getType());
        int type = this.getJDBCType(JavaTypes.getTypeCode(rc), false);
        boolean isXmlAttribute = val.getXmlMapping() == null ? false : val.getXmlMapping().isXmlAttribute();
        SQLBuffer newBufer = new SQLBuffer(this);
        newBufer.append("(xpath('/*/");
        val.appendTo(newBufer);
        if (!isXmlAttribute) {
            newBufer.append("/text()");
        }
        newBufer.append("',").append(val.getColumnAlias(val.getFieldMapping().getColumns()[0])).append("))[1]");
        this.appendCast(buf, newBufer, type);
    }

    @Override
    public String getPlaceholderValueString(Column col) {
        if (col.getType() == -7) {
            return "false";
        }
        return super.getPlaceholderValueString(col);
    }

    protected LargeObjectManager getLargeObjectManager(DelegatingConnection conn) throws SQLException {
        return this.getPGConnection(conn).getLargeObjectAPI();
    }

    protected PGConnection getPGConnection(DelegatingConnection conn) {
        Connection innerConn = conn.getInnermostDelegate();
        if (innerConn instanceof PGConnection) {
            return (PGConnection)innerConn;
        }
        if (innerConn.getClass().getName().startsWith("org.apache.commons.dbcp")) {
            return (PGConnection)this.getDbcpDelegate(innerConn);
        }
        return (PGConnection)this.unwrapConnection(conn, PGConnection.class);
    }

    protected Connection getDbcpDelegate(Connection conn) {
        Connection delegate = null;
        try {
            if (this.dbcpGetDelegate == null) {
                Class<?> dbcpConnectionClass = Class.forName("org.apache.commons.dbcp.DelegatingConnection", true, AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
                Class<?> poolingDataSource = Class.forName("org.apache.commons.dbcp.PoolingDataSource", true, AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
                Method setAccessToUnderlyingConnectionAllowed = poolingDataSource.getMethod("setAccessToUnderlyingConnectionAllowed", Boolean.TYPE);
                Field this$0 = conn.getClass().getDeclaredField("this$0");
                this$0.setAccessible(true);
                Object poolingDataSourceObj = this$0.get(conn);
                setAccessToUnderlyingConnectionAllowed.invoke(poolingDataSourceObj, true);
                this.dbcpGetDelegate = dbcpConnectionClass.getMethod("getInnermostDelegate", new Class[0]);
            }
            delegate = (Connection)this.dbcpGetDelegate.invoke((Object)conn, new Object[0]);
        }
        catch (Exception e) {
            throw new InternalException(_loc.get("dbcp-unwrap-failed"), (Throwable)e);
        }
        if (delegate == null) {
            throw new InternalException(_loc.get("dbcp-unwrap-failed"));
        }
        return delegate;
    }

    private Connection unwrapConnection(Connection conn, Class<?> connectionClass) {
        try {
            if (this.connectionUnwrap == null) {
                this.connectionUnwrap = Connection.class.getMethod("unwrap", Class.class);
            }
            return (Connection)this.connectionUnwrap.invoke((Object)conn, connectionClass);
        }
        catch (Exception e) {
            throw new InternalException(_loc.get("connection-unwrap-failed"), (Throwable)e);
        }
    }

    static {
        try {
            postgresConnectionImpl = ConcreteClassGenerator.getConcreteConstructor(PostgresConnection.class, Connection.class, PostgresDictionary.class);
            postgresPreparedStatementImpl = ConcreteClassGenerator.getConcreteConstructor(PostgresPreparedStatement.class, PreparedStatement.class, Connection.class, PostgresDictionary.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    protected static abstract class PostgresPreparedStatement
    extends DelegatingPreparedStatement {
        private final PostgresDictionary _dict;

        public PostgresPreparedStatement(PreparedStatement ps, Connection conn, PostgresDictionary dict) {
            super(ps, conn);
            this._dict = dict;
        }

        @Override
        protected ResultSet executeQuery(boolean wrap) throws SQLException {
            try {
                return super.executeQuery(wrap);
            }
            catch (SQLException se) {
                ResultSet rs = this.getResultSet(wrap);
                if (rs == null) {
                    throw se;
                }
                return rs;
            }
        }

        @Override
        public void setFetchSize(int i) throws SQLException {
            block3: {
                try {
                    if (this._dict.supportsSetFetchSize) {
                        super.setFetchSize(i);
                    }
                }
                catch (SQLException e) {
                    this._dict.supportsSetFetchSize = false;
                    if (!this._dict.log.isWarnEnabled()) break block3;
                    this._dict.log.warn(_loc.get("psql-no-set-fetch-size"), e);
                }
            }
        }
    }

    protected static abstract class PostgresConnection
    extends DelegatingConnection {
        private final PostgresDictionary _dict;

        public PostgresConnection(Connection conn, PostgresDictionary dict) {
            super(conn);
            this._dict = dict;
        }

        @Override
        protected PreparedStatement prepareStatement(String sql2, boolean wrap) throws SQLException {
            return (PreparedStatement)ConcreteClassGenerator.newInstance(postgresPreparedStatementImpl, super.prepareStatement(sql2, false), this, this._dict);
        }

        @Override
        protected PreparedStatement prepareStatement(String sql2, int rsType, int rsConcur, boolean wrap) throws SQLException {
            return (PreparedStatement)ConcreteClassGenerator.newInstance(postgresPreparedStatementImpl, super.prepareStatement(sql2, rsType, rsConcur, false), this, this._dict);
        }
    }
}

