/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.jdbc.InternalDriver;

public class JDBCBoot {
    private Properties bootProperties = new Properties();
    private static final String NETWORK_SERVER_AUTOSTART_CLASS_NAME = "org.apache.derby.iapi.jdbc.DRDAServerStarter";

    void addProperty(String string, String string2) {
        this.bootProperties.put(string, string2);
    }

    public void boot(String string, PrintWriter printWriter) {
        if (InternalDriver.activeDriver() == null) {
            this.addProperty("derby.service.jdbc", "org.apache.derby.jdbc.InternalDriver");
            this.addProperty("derby.service.authentication", "org.apache.derby.iapi.jdbc.AuthenticationService");
            JDBCBoot.boot(this.bootProperties, printWriter);
        }
    }

    private static void boot(final Properties properties, final PrintWriter printWriter) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Monitor.startMonitor(properties, printWriter);
                if (Boolean.valueOf(PropertyUtil.getSystemProperty("derby.drda.startNetworkServer")).booleanValue()) {
                    try {
                        Monitor.startSystemModule(JDBCBoot.NETWORK_SERVER_AUTOSTART_CLASS_NAME);
                    }
                    catch (StandardException standardException) {
                        Monitor.logTextMessage("J102", standardException.getMessage());
                    }
                }
                return null;
            }
        });
    }
}

