/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.handler;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.servicecomb.governance.handler.Disposable;

public class DisposableMap<V>
extends ConcurrentHashMap<String, Disposable<V>> {
    private static final long serialVersionUID = 7249069246763182397L;
    private static final int EXPIRE_TIME = 600000;
    private final RemoveListener listener;

    public DisposableMap(RemoveListener listener) {
        this.listener = listener;
    }

    @Override
    public Disposable<V> put(String key, Disposable<V> value) {
        Disposable<V> result = super.put(key, value);
        this.checkExpired();
        return result;
    }

    private void checkExpired() {
        ArrayList expired = new ArrayList();
        this.values().forEach((? super T v) -> {
            if (System.currentTimeMillis() - v.lastAccessed() >= 600000L) {
                expired.add(v.getKey());
            }
        });
        expired.forEach(this.listener::onRemoveEntry);
    }

    @Override
    public Disposable<V> get(Object key) {
        return (Disposable)super.get(key);
    }

    public static interface RemoveListener {
        public void onRemoveEntry(String var1);
    }
}

