/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.BundleResourceProvider;
import org.apache.sling.bundleresource.impl.BundleResourceWebConsolePlugin;
import org.apache.sling.bundleresource.impl.PathMapping;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Header(name="Bundle-Activator", value="${@class}")
public class Activator
implements BundleActivator,
BundleListener {
    public static final String BUNDLE_RESOURCE_ROOTS = "Sling-Bundle-Resources";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Long, BundleResourceProvider[]> bundleResourceProviderMap = new HashMap<Long, BundleResourceProvider[]>();

    public void start(BundleContext context) throws Exception {
        Bundle[] bundles;
        context.addBundleListener((BundleListener)this);
        for (Bundle bundle : bundles = context.getBundles()) {
            if (bundle.getState() != 32) continue;
            this.addBundleResourceProvider(bundle);
        }
        BundleResourceWebConsolePlugin.initPlugin(context);
    }

    public void stop(BundleContext context) throws Exception {
        BundleResourceWebConsolePlugin.destroyPlugin();
        context.removeBundleListener((BundleListener)this);
        for (BundleResourceProvider[] providers : this.bundleResourceProviderMap.values()) {
            for (BundleResourceProvider p : providers) {
                try {
                    p.unregisterService();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        this.bundleResourceProviderMap.clear();
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.addBundleResourceProvider(event.getBundle());
                break;
            }
            case 4: {
                this.removeBundleResourceProvider(event.getBundle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addBundleResourceProvider(Bundle bundle) {
        BundleResourceProvider[] providers = null;
        try {
            Activator activator = this;
            synchronized (activator) {
                if (this.bundleResourceProviderMap.get(bundle.getBundleId()) != null) {
                    return;
                }
                String prefixes = (String)bundle.getHeaders().get(BUNDLE_RESOURCE_ROOTS);
                if (prefixes != null) {
                    this.log.debug("addBundleResourceProvider: Registering resources '{}' for bundle {}:{} ({}) as service ", new Object[]{prefixes, bundle.getSymbolicName(), bundle.getVersion(), bundle.getBundleId()});
                    PathMapping[] roots = PathMapping.getRoots(prefixes);
                    providers = new BundleResourceProvider[roots.length];
                    boolean bl = false;
                    BundleResourceCache cache = new BundleResourceCache(bundle);
                    for (PathMapping path : roots) {
                        void var6_10;
                        BundleResourceProvider brp;
                        providers[var6_10] = brp = new BundleResourceProvider(cache, path);
                        ++var6_10;
                    }
                    this.bundleResourceProviderMap.put(bundle.getBundleId(), providers);
                }
            }
            if (providers != null) {
                for (Activator activator2 : providers) {
                    long id = ((BundleResourceProvider)((Object)activator2)).registerService();
                    this.log.debug("addBundleResourceProvider: Service ID = {}", (Object)id);
                }
            }
        }
        catch (Throwable t) {
            this.log.error("activate: Problem while registering bundle resources for bundle " + bundle.getSymbolicName() + ":" + bundle.getVersion() + " (" + bundle.getBundleId() + ")", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBundleResourceProvider(Bundle bundle) {
        BundleResourceProvider[] bundleResourceProviderArray = this;
        synchronized (this) {
            BundleResourceProvider[] brp = this.bundleResourceProviderMap.remove(bundle.getBundleId());
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (brp != null) {
                this.log.debug("removeBundleResourceProvider: Unregistering resources for bundle {}:{} ({})", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), bundle.getBundleId()});
                for (BundleResourceProvider provider : brp) {
                    try {
                        provider.unregisterService();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
            return;
        }
    }
}

