/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.http;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.sling.testing.tools.http.RequestExecutor;

public class RequestDocumentor {
    public static final String OUTPUT_BASE = "./target/" + RequestDocumentor.class.getSimpleName();
    private final String name;

    public RequestDocumentor(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.name + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateDocumentation(RequestExecutor executor, String[] metadata) throws IOException {
        File f = this.getOutputFile();
        File dir = f.getParentFile();
        dir.mkdirs();
        if (!dir.isDirectory()) {
            throw new IOException("Failed to create output folder " + dir.getAbsolutePath());
        }
        PrintWriter pw = new PrintWriter(new FileWriter(f, true));
        try {
            System.out.println("Appending documentation of " + executor + " to " + f.getAbsolutePath());
            this.documentRequest(pw, executor, metadata);
        }
        finally {
            pw.flush();
            pw.close();
        }
    }

    protected File getOutputFile() {
        return new File(OUTPUT_BASE + "/" + this.name + ".txt");
    }

    protected void documentRequest(PrintWriter pw, RequestExecutor executor, String[] metadataArray) throws IOException {
        HttpEntityEnclosingRequestBase heb;
        HashMap<String, String> m = new HashMap<String, String>();
        if (metadataArray.length % 2 != 0) {
            throw new IllegalArgumentException("Metadata array must be of even size, got " + metadataArray.length);
        }
        for (int i = 0; i < metadataArray.length; i += 2) {
            m.put(metadataArray[i], metadataArray[i + 1]);
        }
        pw.println();
        pw.println("====================================================================================");
        pw.print("=== ");
        pw.print((String)m.get("title"));
        pw.println(" ===");
        pw.println((String)m.get("description"));
        pw.print("\n=== ");
        pw.print("REQUEST");
        pw.println(" ===");
        pw.print("Method: ");
        pw.println(executor.getRequest().getMethod());
        pw.print("URI: ");
        pw.println(executor.getRequest().getURI());
        Header[] allHeaders = executor.getRequest().getAllHeaders();
        if (allHeaders != null && allHeaders.length > 0) {
            pw.println("Headers:");
            for (Header h : allHeaders) {
                pw.print(h.getName());
                pw.print(":");
                pw.println(h.getValue());
            }
        }
        if (executor.getRequest() instanceof HttpEntityEnclosingRequestBase && (heb = (HttpEntityEnclosingRequestBase)executor.getRequest()).getEntity() != null) {
            pw.print("Content-Type:");
            pw.println(heb.getEntity().getContentType().getValue());
            pw.println("Content:");
            InputStream is = heb.getEntity().getContent();
            byte[] buffer = new byte[16384];
            int count = 0;
            while ((count = is.read(buffer, 0, buffer.length)) > 0) {
                pw.write(new String(buffer, 0, count));
            }
            pw.println();
        }
        pw.print("\n=== ");
        pw.print("RESPONSE");
        pw.println(" ===");
        pw.print("Content-Type:");
        pw.println(executor.getResponse().getEntity().getContentType().getValue());
        pw.println("Content:");
        pw.println(executor.getContent());
        pw.println("====================================================================================");
    }
}

