/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectUtil {
    private static final String PROJECT_CMD = "project";
    private static final String CREATE_OPTION = "create";
    private static final String BIND_OPTION = "bind";
    private static final String URL_OPTION = "--url";
    private static final String NAME_OPTION = "--name";
    private static final String LANGUAGE_OPTION = "--language";
    private static final String TYPE_OPTION = "--type";
    private static final String PATH_OPTION = "--path";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createProject(String name, String path, String url, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CreateProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(new String[]{"--insecure"}, new String[]{PROJECT_CMD, CREATE_OPTION}, new String[]{URL_OPTION, url, "--conid", conid}, new String[]{path});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("Project create failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("Project create had 0 return code but the output is empty");
                throw new IOException("The output from project create is empty.");
            }
            JSONObject resultJson = new JSONObject(result.getOutput());
            if (!"success".equals(resultJson.getString("status"))) {
                String msg = "Project create failed for project: " + name + " with output: " + result.getOutput();
                Logger.logError(msg);
                throw new IOException(msg);
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bindProject(String name, String path, String language, String projectType, String conid, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.BindingProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            String[] options = new String[]{NAME_OPTION, name, LANGUAGE_OPTION, language, TYPE_OPTION, projectType, PATH_OPTION, path, "--conid", conid};
            process = CLIUtil.runCWCTL(new String[]{"--insecure"}, new String[]{PROJECT_CMD, BIND_OPTION}, options);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("Project bind failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static ProjectInfo validateProject(String name, String path, String hint, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ValidateProjectTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            process = hint == null ? CLIUtil.runCWCTL(new String[]{"--insecure"}, new String[]{PROJECT_CMD, CREATE_OPTION}, new String[]{"--conid", conid}, new String[]{path}) : CLIUtil.runCWCTL(new String[]{"--insecure"}, new String[]{PROJECT_CMD, CREATE_OPTION}, new String[]{TYPE_OPTION, hint, "--conid", conid}, new String[]{path});
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("Project validate failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("Project validate had 0 return code but the output is empty");
                throw new IOException("The output from project validate is empty.");
            }
            JSONObject resultJson = new JSONObject(result.getOutput());
            if ("success".equals(resultJson.getString("status")) && resultJson.has("result")) {
                JSONObject typeJson = resultJson.getJSONObject("result");
                String language = typeJson.getString("language");
                String projectType = typeJson.getString("projectType");
                ProjectInfo projectInfo = new ProjectInfo(projectType, language);
                return projectInfo;
            }
            String msg = "Validation failed for project: " + name + " with output: " + result.getOutput();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

