/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.contexts.ContextObjectSupplier;
import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.fx.core.di.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;

@Component(service={ExtendedObjectSupplier.class}, property={"dependency.injection.annotation:String=org.eclipse.fx.core.di.Service"})
public class ServiceSupplier
extends ExtendedObjectSupplier {
    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        ParameterizedType t;
        Type desiredType = descriptor.getDesiredType();
        Bundle b = FrameworkUtil.getBundle((Class)requestor.getRequestingObjectClass());
        if (desiredType instanceof ParameterizedType && ((t = (ParameterizedType)desiredType).getRawType() == Collections.class || t.getRawType() == List.class)) {
            return this.handleCollection(b, t.getActualTypeArguments()[0], requestor, track && ((Service)descriptor.getQualifier(Service.class)).dynamic());
        }
        return this.handleSingle(b, desiredType, requestor, descriptor, track && ((Service)descriptor.getQualifier(Service.class)).dynamic());
    }

    private Object handleSingle(Bundle bundle, Type t, IRequestor requestor, IObjectDescriptor descriptor, boolean track) {
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        }
        Class cl = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
        try {
            Object[] serviceReferences = context.getServiceReferences(cl.getName(), null);
            Arrays.sort(serviceReferences);
            if (serviceReferences.length > 0) {
                return context.getService((ServiceReference)serviceReferences[0]);
            }
            Requestor rr = (Requestor)requestor;
            ContextObjectSupplier cp = (ContextObjectSupplier)rr.getPrimarySupplier();
            Collection serviceReferences2 = context.getServiceReferences(IContextFunction.class, null);
            ArrayList l = new ArrayList(serviceReferences2);
            Collections.sort(l);
            for (ServiceReference r : l) {
                if (!cl.getName().equals(r.getProperty("dependency.injection.annotation"))) continue;
                Named qualifier = (Named)descriptor.getQualifier(Named.class);
                return ((IContextFunction)context.getService(r)).compute(cp.getContext(), qualifier == null ? cl.getName() : qualifier.value());
            }
            if (track) {
                context.addServiceListener((ServiceListener)new ServiceHandler(requestor, context, cl));
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return IInjector.NOT_A_VALUE;
    }

    private List<Object> handleCollection(Bundle bundle, Type t, IRequestor requestor, boolean track) {
        ArrayList<Object> rv = new ArrayList<Object>();
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        }
        Class cl = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
        try {
            Object[] serviceReferences = context.getServiceReferences(cl.getName(), null);
            if (serviceReferences != null) {
                Arrays.sort(serviceReferences);
                Object[] objectArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    Object serviceReference = objectArray[n2];
                    rv.add(context.getService((ServiceReference)serviceReference));
                    if (track) {
                        context.addServiceListener((ServiceListener)new ServiceHandler(requestor, context, cl));
                    }
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return rv;
    }

    static class ServiceHandler
    implements ServiceListener {
        private final IRequestor requestor;
        private final BundleContext bundleContext;
        private final Class<?> type;

        public ServiceHandler(IRequestor requestor, BundleContext bundleContext, Class<?> type) {
            this.requestor = requestor;
            this.bundleContext = bundleContext;
            this.type = type;
        }

        public void serviceChanged(ServiceEvent event) {
            String[] data;
            if (!this.requestor.isValid()) {
                this.bundleContext.removeServiceListener((ServiceListener)this);
                return;
            }
            String[] stringArray = data = (String[])event.getServiceReference().getProperty("objectClass");
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                String d = stringArray[n2];
                if (this.type.getName().equals(d)) {
                    this.requestor.resolveArguments(false);
                    break;
                }
                if (d.equals(IContextFunction.SERVICE_NAME) && this.type.getName().equals(event.getServiceReference().getProperty("service.context.key"))) {
                    this.requestor.resolveArguments(false);
                    break;
                }
                ++n2;
            }
        }
    }
}

