#!/bin/bash

# Set to 1 for dry run (testing), 0 for actual execution
DRY_RUN=0

# This script uses the gutindex_update.py program to convert existing
# GUTINDEX files to updated ones with the ".new" extension in the current directory.
# If those files exist, they are moved to the ~hhelpers directory.
# From there, other code picks them up for display.

# the script will attempt to build new files. start fresh.
rm -f GUTINDEX*.new
rm -f results.txt

echo "----- $(date) -----" >> logfile
python3 gutindex_update.py

# for testing, do not write to the ~hhelpers directory

if [ $DRY_RUN -eq 1 ]; then
    echo "Dry run mode - exiting without saving to ~hhelpers"
    exit 0
fi

# if here, this is a real update. Move available files to ~hhelpers

success_count=0
for B in GUTINDEX.2025 GUTINDEX.ALL GUTINDEX.zip; do
    if [ -f $B.new ]; then
        mv $B.new /home/hhelpers/$B
        success_count=$((success_count + 1))
    fi
done

if [ $success_count -ne 3 ]; then
    echo -e "GUTINDEX update failed." | mail -s "Error in GUTINDEX update" rfrank
fi



