unit OpenForm;
{OpenForm unit for Gecko Browser, contains open location dialog + methods}
{v1.0 Written by Dave Murray <irongut@vodafone.net>, October - November 2003}
{v1.1 Written by Dave Murray, March 2004}
{v1.2 Written by Dave Murray, April + July 2004}
{Gecko Browser v1.2 was written using Mozilla ActiveX Control v1.7.1}

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Gecko Browser framework.
 *
 * The Initial Developer of the Original Code is
 * Conspiracy Software.
 * Portions created by the Initial Developer are Copyright (C) 2003 - 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Dave Murray <irongut@vodafone.net>
 *   Sterling Bates <sblistserv@bigbangco.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)


interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  TfrmOpen = class(TForm)
    grpbxOpen: TGroupBox;
      edtURL: TEdit;
      spdbtnChooseFile: TSpeedButton;
    grpbxButtons: TGroupBox;
      btnOk: TBitBtn;
      btnCancel: TBitBtn;
    dlgOpen: TOpenDialog;
    procedure spdbtnChooseFileClick(Sender: TObject);
    procedure edtURLKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmOpen: TfrmOpen;

implementation

{$R *.dfm}

procedure TfrmOpen.spdbtnChooseFileClick(Sender: TObject);
{show open file dialog + update URL if successful}
begin
  dlgOpen.FileName := '';
  if dlgOpen.Execute then edtURL.Text := 'file:///' + dlgOpen.FileName;
end; {procedure TfrmOpen.spdbtnChooseFileClick}

procedure TfrmOpen.edtURLKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
{if enter pressed then click OK}
begin
  if (Key = VK_RETURN) then btnOk.Click;
end; {procedure TfrmOpen.edtURLKeyDown}

end.
