/* FILEMANAGER  --  An FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
*  Author: Duong Thanh An - technical@anisolution.com (core)
*  Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)
*	
*  Copyright (C) 2004 Anisolution.com
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Anisolution.com
*  http://www.anisolution.com
*  HCMC Vietnam
*  info@anisolution.com
*/
/*		
	 Copyright notice:
	 XUL File Manager is freeware with open source code. 
	 As long as you keep the copyright message, you can 
	 play with the code for your own purposes but you can
	 not distribute the altered version. You can not sell 
	 XUL File Manager or use it for commercial purposes.
	 Please contact us for commercial uses.

	 BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR THE PROGRAM
*/

var extensions = new Array();

function extensionInstallation() {
	//add new extension here by calling the isntallExtension function
}

function installExtension(ext) {
	//validate extension ...

	//install
	extensions[extensions.length] = ext;
}
function controlContextMenu() {
	
	var contentContextMenu = document.getElementById("contentContextMenu");
	var contextPopupFirstSepatator = document.getElementById("contextPopupFirstSepatator");

	//removing all the ext menu item
	for(var i = contentContextMenu.childNodes.length - 1; i >= 0; i --) {
		var item = contentContextMenu.childNodes[i];
		if(item.nodeName != "menuitem" && item.nodeName != "menu") continue;
		if(!item.isExtension) continue;
		contentContextMenu.removeChild(item);
	}

	//add new extension menu
	var first = true;
	for(var i = 0; i < extensions.length; i++) {
		var ext = extensions[i];
		var info = ext.getDisplayInfo();
		if(!info) {
			//alert("info is null");
			continue;
		}
		
		contentContextMenu.insertBefore(createMenuItemForExtInfo(info, first), contextPopupFirstSepatator);
		first = false;
	}
	contextPopupFirstSepatator.setAttribute("hidden", first);
}
function extensionMenuItemOnCommand(target) {
	target.extensionInfo.action();
}
function createMenuItemForExtInfo(info, first) {
	if(info.children.length == 0) {
		var menuItem = document.createElement("menuitem");
		menuItem.setAttribute("label", info.caption);
		menuItem.setAttribute("image", info.iconImage);
		menuItem.extensionInfo = info;
		menuItem.isExtension = true;
		menuItem.setAttribute("oncommand", "extensionMenuItemOnCommand(this);");
		menuItem.setAttribute("class", "menuitem-iconic");

		var style = "";
		if(first) style += "font-weight: 900;";
		if(style) menuItem.setAttribute("style", style);

		return menuItem;
	} else {
		var menu = document.createElement("menu");
		menu.setAttribute("label", info.caption);
		//menu.setAttribute("image", info.iconImage);
		var menuPopup = document.createElement("menupopup");
		menu.appendChild(menuPopup);
		menu.extensionInfo = info;
		menu.isExtension = true;
		menu.setAttribute("class", "menu-iconic");
		menu.setAttribute("image", info.iconImage);

		var style = "";
		if(style) menu.setAttribute("style", style);
		
		for(var i = 0; i < info.children.length; i++) {
			menuPopup.appendChild(createMenuItemForExtInfo(info.children[i], first && (i == 0)));
		}

		return menu;
	}
}
// util functions
function getListSelectionModel() {
	var list = document.getElementById("contentList");
	if(!list) return null;
	var totalFiles = 0;
	var totalFolders = 0;
	var ext = "";
	var paths = "";
	var names = "";
	for(var i = 0 ; i < list.view.rowCount; i++){
		if(list.view.selection.isSelected(i)) {
			var item = list.view.getItemAtIndex(i);
			if(item.fsData.fstype == "file") {
				if(item.fsData.name.match(/\.([^\.]+)$/)) ext = RegExp.$1;
				totalFiles ++;
			}
			else totalFolders ++;
			if(paths != "") paths += "\n";
			paths += item.fsData.absolutePath;

			if(names != "") names += "\n";
			names += item.fsData.name;
		}
	}

	var info = new Object();
	info.totalFiles = totalFiles;
	info.totalFolders = totalFolders;
	info.firstExt = ext;
	info.selectedPaths = paths;
	info.selectedNames = names;

	return info;
}
function isSingleFileSelection(info) {
	return (info.totalFiles == 1 && info.totalFolders == 0);
}
function isSingleFolderSelection(info) {
	return (info.totalFiles == 0 && info.totalFolders == 1);
}
function isFileOfType(info, exts) {
	if(!isSingleFileSelection(info)) return false;
	var re = new RegExp(exts, "i");
	return info.firstExt.match(re);
}

//The ExtensionMenuItem class
function ExtensionMenuItem() {
	this.caption = null;
	this.iconImage = null;
	this.action = null;
	this.children = new Array();

	this.appendChild = function(child) {
		this.action = null;
		this.children[this.children.length] = child;
	}
}