/*$Id: RulesParser.h,v 1.9 2006/08/20 16:39:04 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef RULEPARSER_H
#define RULEPARSER_H

#include "Common.h"
#include "Rule.h"
#include "Rules.h"

class RulesParser{
 private:
	pcre *ruleRE, *msgRE, *referenceRE;
	pcre *fidRE, *revRE, *headerRE, *bodyRE, *urlRE;
	pcre *urlContentRE, *headersContentRE, *bodyContentRE; 
	
	static const int RULEBUFLEN = 4096;
	static const int ERRBUFLEN = 512;
	static const int OVECCOUNT = 15;    /* should be a multiple of 3 */
	
	char errmsg[ERRBUFLEN];
	
	void err_append(const char *fmt, ...);
	bool emptyString(char *p);
	bool comentedString(char *p);
	int compileRE(pcre **re, const char *pattern, const char *name);
	int compileREs();
	
	void freeRE(pcre **re);
	void freeREs();
	void remove_substring(char *str, unsigned int b, unsigned int e);
	bool parseReference(char *options, Rule *rule);
	char *parseOption(pcre *re, char *options);
	char *parseContentOption(pcre *re, char *options, int *nocase);
	
	bool parseContent(char *pattern, const char *name,
			  PatternMatchData *matchData, char *errbuf, int errbuflen);
	bool parseRE(char *pattern, const char *name, 
		     RE * re, char *errbuf, int errbuflen);
	
	char *parseOptions(char *options, Rule *rule);
	void parseLine(Rules *rules, char *line, int linenr);
 public:
	RulesParser(char **error);
	~RulesParser();

	Rule* parseRule(const char *rule, char **error);
	void parseRules(Rules *rules, const char *input, char **error);
};


#endif
