/*$Id: Rule.cpp,v 1.8 2006/08/20 16:39:04 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#include "Rule.h"
#include "Wrap.h"
#include "Error.h"

Rule::Rule()
{
	TRACE("constructor %08x", this);
	actionID = -1;
	action = NULL;
	msg = NULL;
	fid = 0; 
	rev = 0;
	urlREs.clear();
	headersREs.clear();
	bodyREs.clear();	
	references.clear();	
	url_content.clear();
	headers_content.clear();
	body_content.clear();
}

Rule::~Rule()
{
	TRACE("destructor %08x", this);
	
}

void Rule::init()
{
	
	
}

void Rule::reset()
{
	list<RE>::iterator it;
	list<reference>::iterator it2;
	list<PatternMatchData>::iterator it3;

	if (action)
		free(action);
	if (msg)
		free(msg);

	for(it = urlREs.begin(); it != urlREs.end(); ++it){
		free(it->re_compiled);
		free(it->pattern);
	}
	for(it = headersREs.begin(); it != headersREs.end(); ++it){
		free(it->re_compiled);
		free(it->pattern);
	}
	
	for(it = bodyREs.begin(); it != bodyREs.end(); ++it){
		free(it->re_compiled);
		free(it->pattern);
	}
	
	for(it2 = references.begin(); it2 != references.end(); ++it2){
		free(it2->system);
		free(it2->ruleId);
	}
	
	for(it3 = url_content.begin(); it3 != url_content.end(); ++it3){
		free(it3->pattern_buf);
	}

	for(it3 = headers_content.begin(); it3 != headers_content.end(); ++it3){
		free(it3->pattern_buf);
	}

	for(it3 = body_content.begin(); it3 != body_content.end(); ++it3){
		free(it3->pattern_buf);
	}

	urlREs.clear();
	headersREs.clear();
	bodyREs.clear();
	references.clear();
	url_content.clear();
	headers_content.clear();
	body_content.clear();
}


bool Rule::urlRule() const
{
	return (urlREs.size() || url_content.size());
}

bool Rule::headersRule() const
{
	return (headersREs.size() || headers_content.size());
}

bool Rule::bodyRule() const
{
	return (bodyREs.size() || body_content.size());
}
