/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.Component;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.mozilla.jrex.log.JRexL;

public final class JRexResource {
    private static final String className = JRexResource.class.getName();
    private static final char MNEMONICCHAR = '&';
    private static final char ACCELCHAR = '@';
    private static final String MNEMONICSTR = "&";
    private static final String ACCELSTR = "@";
    private static ResourceBundle rBundle = null;

    private JRexResource() {
    }

    public static String getString(String resourceId) {
        StringBuffer resource;
        block4: {
            resource = null;
            try {
                resource = new StringBuffer(rBundle.getString(resourceId));
            }
            catch (MissingResourceException e) {
                if (!JRexL.on) break block4;
                JRexL.log(className, "**** getString() MissingResourceException <" + e.getMessage() + "> ****");
            }
        }
        if (resource != null) {
            int index = resource.indexOf(MNEMONICSTR);
            if (index != -1) {
                resource.deleteCharAt(index);
            }
            return (index = resource.lastIndexOf(ACCELSTR)) == -1 ? resource.toString().trim() : resource.substring(0, index).trim();
        }
        return resourceId;
    }

    public static char getMnemonic(String resourceId) {
        String resource;
        block2: {
            resource = null;
            try {
                resource = rBundle.getString(resourceId);
            }
            catch (MissingResourceException e) {
                if (!JRexL.on) break block2;
                JRexL.log(className, "**** getMnemonic() MissingResourceException <" + e.getMessage() + "> ****");
            }
        }
        return resource == null ? (char)'\u0000' : JRexResource.getMnemonicChar(resource);
    }

    public static char getAccelerator(String resourceId) {
        String resource;
        block2: {
            resource = null;
            try {
                resource = rBundle.getString(resourceId);
            }
            catch (MissingResourceException e) {
                if (!JRexL.on) break block2;
                JRexL.log(className, "**** getMnemonic() MissingResourceException <" + e.getMessage() + "> ****");
            }
        }
        return resource == null ? (char)'\u0000' : JRexResource.getMnemonicChar(resource);
    }

    public static char getMnemonicChar(String resStr) {
        int index = resStr.indexOf(38);
        return index == -1 ? (char)'\u0000' : resStr.charAt(index + 1);
    }

    public static char getAcceleratorChar(String resStr) {
        int index = resStr.lastIndexOf(64);
        return index == -1 ? (char)'\u0000' : resStr.charAt(index + 1);
    }

    public static ImageIcon getIcon(String iconName) {
        URL imgURL = JRexResource.class.getClassLoader().getResource("icons/" + iconName + ".gif");
        return imgURL == null ? null : new ImageIcon(imgURL);
    }

    public static void showInfoMessage(Component parent, String message, boolean suppress) {
        JOptionPane.showMessageDialog(parent, message, JRexResource.getString("INFO_TITLE"), 1);
    }

    public static void showWarningMessage(Component parent, String message, boolean suppress) {
        JOptionPane.showMessageDialog(parent, message, JRexResource.getString("WAR_TITLE"), 2);
    }

    public static void showErrorMessage(Component parent, String message, boolean suppress) {
        JOptionPane.showMessageDialog(parent, message, JRexResource.getString("ERR_TITLE"), 0);
    }

    public static void showFormattedWarningMessage(Component parent, String message, Object[] formatArray, boolean suppress) {
        JOptionPane.showMessageDialog(parent, new MessageFormat(message).format(formatArray), JRexResource.getString("WAR_TITLE"), 2);
    }

    static {
        try {
            rBundle = ResourceBundle.getBundle("jrex", Locale.getDefault(), JRexResource.class.getClassLoader());
        }
        catch (Exception ex) {
            JRexL.printStackTrace(ex);
        }
    }
}

