/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.Stack;
import org.mozilla.dom.NamedNodeMapImpl;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeListImpl;
import org.mozilla.dom.SharedUtils;
import org.mozilla.dom.UnsupportedException;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.dom.events.EventImpl;
import org.mozilla.dom.events.EventListenerImpl;
import org.mozilla.interfaces.inIDOMUtils;
import org.mozilla.interfaces.nsIDOM3Node;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMNamedNodeMap;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIVariant;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class NodeImpl
implements Node,
EventTarget {
    protected nsIDOMNode moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public static NodeImpl getDOMInstance(nsIDOMNode mozInst) {
        NodeImpl node = (NodeImpl)instances.get(mozInst);
        return node == null ? new NodeImpl(mozInst) : node;
    }

    public nsIDOMNode getInstance() {
        return this.moz;
    }

    public NodeImpl(nsIDOMNode mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public Node appendChild(Node newChild) {
        nsIDOMNode mozNewchild = ((NodeImpl)newChild).getInstance();
        nsIDOMNode result = this.getInstance().appendChild(mozNewchild);
        return NodeFactory.getNodeInstance(result);
    }

    public String lookupPrefix(String namespaceURI) {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        String result = DOM3MozObject.lookupPrefix(namespaceURI);
        return result;
    }

    public void setNodeValue(String nodeValue) {
        this.getInstance().setNodeValue(nodeValue);
    }

    public boolean isSameNode(Node other) {
        nsIDOMNode mozOther = ((NodeImpl)other).getInstance();
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        boolean result = DOM3MozObject.isSameNode(mozOther);
        return result;
    }

    public Node cloneNode(boolean deep) {
        nsIDOMNode result = this.getInstance().cloneNode(deep);
        return NodeFactory.getNodeInstance(result);
    }

    public Node getFirstChild() {
        nsIDOMNode current = this.getInstance();
        if (NodeFactory.getExpandFrames()) {
            if (SharedUtils.isFrameNode(current)) {
                return SharedUtils.frameNodeToDocument(current);
            }
            return NodeFactory.getNodeInstance(current.getFirstChild());
        }
        return NodeFactory.getNodeInstance(current.getFirstChild());
    }

    public void setTextContent(String textContent) {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        DOM3MozObject.setTextContent(textContent);
    }

    public boolean isEqualNode(Node arg) {
        nsIDOMNode mozArg = ((NodeImpl)arg).getInstance();
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        boolean result = DOM3MozObject.isEqualNode(mozArg);
        return result;
    }

    public void normalize() {
        this.getInstance().normalize();
    }

    public boolean isSupported(String feature, String version) {
        boolean result = this.getInstance().isSupported(feature, version);
        return result;
    }

    public Object getFeature(String feature, String version) {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        nsISupports result = DOM3MozObject.getFeature(feature, version);
        return result;
    }

    public Object getUserData(String key) {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        nsIVariant result = DOM3MozObject.getUserData(key);
        return result;
    }

    public String getPrefix() {
        String result = this.getInstance().getPrefix();
        return result;
    }

    public short getNodeType() {
        int result = this.getInstance().getNodeType();
        return (short)result;
    }

    public Node getNextSibling() {
        nsIDOMNode currentNode = this.getInstance();
        if (NodeFactory.getExpandFrames()) {
            inIDOMUtils utils;
            nsIDOMNode parentNode;
            if (SharedUtils.isHTMLNode(currentNode) && (parentNode = (utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}")).getParentForNode(currentNode, false)) != null) {
                return null;
            }
            nsIDOMNode result = currentNode.getNextSibling();
            return NodeFactory.getNodeInstance(result);
        }
        return NodeFactory.getNodeInstance(currentNode.getNextSibling());
    }

    public Node getLastChild() {
        nsIDOMNode current = this.getInstance();
        if (NodeFactory.getExpandFrames()) {
            if (SharedUtils.isFrameNode(current)) {
                return SharedUtils.frameNodeToDocument(current);
            }
            return NodeFactory.getNodeInstance(current.getLastChild());
        }
        return NodeFactory.getNodeInstance(current.getLastChild());
    }

    public boolean hasChildNodes() {
        nsIDOMNode current = this.getInstance();
        if (NodeFactory.getExpandFrames()) {
            if (SharedUtils.isFrameNode(current)) {
                return true;
            }
            return current.hasChildNodes();
        }
        return current.hasChildNodes();
    }

    public short compareDocumentPosition(Node other) {
        if (NodeFactory.getExpandFrames()) {
            Node frame2;
            Document startDoc2;
            Document startDoc1 = this.getOwnerDocument();
            if (startDoc1.isSameNode(startDoc2 = other.getOwnerDocument())) {
                nsIDOMNode mozOther = ((NodeImpl)other).getInstance();
                nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
                int result = DOM3MozObject.compareDocumentPosition(mozOther);
                return (short)result;
            }
            Stack<Document> docs1 = new Stack<Document>();
            Document d = startDoc1;
            while (d != null) {
                docs1.push(d);
                Node p = d.getParentNode();
                if (p == null) {
                    d = null;
                    continue;
                }
                d = p.getOwnerDocument();
            }
            Stack<Document> docs2 = new Stack<Document>();
            Document d2 = startDoc2;
            while (d2 != null) {
                docs2.push(d2);
                Node p = d2.getParentNode();
                if (p == null) {
                    d2 = null;
                    continue;
                }
                d2 = p.getOwnerDocument();
            }
            Document lastCommon = null;
            Document doc1 = null;
            Document doc2 = null;
            while (!docs1.isEmpty() && !docs2.isEmpty() && (doc1 = (Document)docs1.pop()).isSameNode(doc2 = (Document)docs2.pop())) {
                lastCommon = doc1;
            }
            if (lastCommon == null || doc1 == null || doc2 == null) {
                return 33;
            }
            Node frame1 = doc1.getParentNode();
            if (frame1 == null) {
                frame1 = docs1.isEmpty() ? this : ((Document)docs1.peek()).getParentNode();
            }
            if ((frame2 = doc2.getParentNode()) == null) {
                frame2 = docs2.isEmpty() ? other : ((Document)docs2.peek()).getParentNode();
            }
            assert (frame1 != null && frame2 != null);
            assert (frame1.getOwnerDocument().isSameNode(frame2.getOwnerDocument()));
            nsIDOM3Node mozFrame1 = (nsIDOM3Node)((NodeImpl)frame1).getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
            nsIDOMNode mozFrame2 = ((NodeImpl)frame2).getInstance();
            int result = mozFrame1.compareDocumentPosition(mozFrame2);
            return (short)result;
        }
        nsIDOMNode mozOther = ((NodeImpl)other).getInstance();
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        int result = DOM3MozObject.compareDocumentPosition(mozOther);
        return (short)result;
    }

    public String getBaseURI() {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        String result = DOM3MozObject.getBaseURI();
        return result;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedException();
    }

    public boolean hasAttributes() {
        boolean result = this.getInstance().hasAttributes();
        return result;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        nsIDOMNode mozNewchild = ((NodeImpl)newChild).getInstance();
        nsIDOMNode mozRefchild = ((NodeImpl)refChild).getInstance();
        nsIDOMNode result = this.getInstance().insertBefore(mozNewchild, mozRefchild);
        return NodeFactory.getNodeInstance(result);
    }

    public NodeList getChildNodes() {
        nsIDOMNode current = this.getInstance();
        if (NodeFactory.getExpandFrames()) {
            if (SharedUtils.isFrameNode(current)) {
                return new NodeListImpl(((NodeImpl)((Object)SharedUtils.frameNodeToDocument(current))).getInstance().getChildNodes());
            }
            return new NodeListImpl(current.getChildNodes());
        }
        return new NodeListImpl(current.getChildNodes());
    }

    public Node getParentNode() {
        nsIDOMNode currentNode = this.getInstance();
        if (NodeFactory.getExpandFrames()) {
            if (currentNode.getNodeType() == 9) {
                inIDOMUtils utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
                nsIDOMNode parentNode = utils.getParentForNode(currentNode, false);
                if (parentNode == null) {
                    return null;
                }
                return NodeFactory.getNodeInstance(parentNode);
            }
            nsIDOMNode parentNode = this.getInstance().getParentNode();
            if (parentNode != null && parentNode.getNodeType() == 9) {
                inIDOMUtils utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
                nsIDOMNode parentParentNode = utils.getParentForNode(parentNode, false);
                if (parentParentNode == null) {
                    return NodeFactory.getNodeInstance(parentNode);
                }
                return NodeFactory.getNodeInstance(parentParentNode);
            }
            return NodeFactory.getNodeInstance(parentNode);
        }
        return NodeFactory.getNodeInstance(currentNode.getParentNode());
    }

    public String getNodeName() {
        String result = this.getInstance().getNodeName();
        if (NodeFactory.getConvertNodeNamesToLowerCase()) {
            return result.toLowerCase();
        }
        return result;
    }

    public Node getPreviousSibling() {
        nsIDOMNode currentNode = this.getInstance();
        if (NodeFactory.getExpandFrames()) {
            inIDOMUtils utils;
            nsIDOMNode parentNode;
            if (SharedUtils.isHTMLNode(currentNode) && (parentNode = (utils = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}")).getParentForNode(currentNode, false)) != null) {
                return null;
            }
            nsIDOMNode result = currentNode.getPreviousSibling();
            return NodeFactory.getNodeInstance(result);
        }
        return NodeFactory.getNodeInstance(currentNode.getPreviousSibling());
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        nsIDOMNode mozNewchild = ((NodeImpl)newChild).getInstance();
        nsIDOMNode mozOldchild = ((NodeImpl)oldChild).getInstance();
        nsIDOMNode result = this.getInstance().replaceChild(mozNewchild, mozOldchild);
        return NodeFactory.getNodeInstance(result);
    }

    public Document getOwnerDocument() {
        nsIDOMDocument result = this.getInstance().getOwnerDocument();
        return (Document)NodeFactory.getNodeInstance((nsIDOMNode)result);
    }

    public String getLocalName() {
        String result = this.getInstance().getLocalName();
        if (NodeFactory.getConvertNodeNamesToLowerCase()) {
            return result.toLowerCase();
        }
        return result;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedException();
    }

    public String getTextContent() {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        String result = DOM3MozObject.getTextContent();
        return result;
    }

    public String lookupNamespaceURI(String prefix) {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node)this.getInstance().queryInterface("{29fb2a18-1dd2-11b2-8dd9-a6fd5d5ad12f}");
        String result = DOM3MozObject.lookupNamespaceURI(prefix);
        return result;
    }

    public String getNodeValue() {
        String result = this.getInstance().getNodeValue();
        return result;
    }

    public Node removeChild(Node oldChild) {
        nsIDOMNode mozOldchild = ((NodeImpl)oldChild).getInstance();
        nsIDOMNode result = this.getInstance().removeChild(mozOldchild);
        return NodeFactory.getNodeInstance(result);
    }

    public NamedNodeMap getAttributes() {
        nsIDOMNamedNodeMap result = this.getInstance().getAttributes();
        return new NamedNodeMapImpl(result);
    }

    public String getNamespaceURI() {
        String result = this.getInstance().getNamespaceURI();
        if (result == null) {
            return "";
        }
        String prefix = this.lookupPrefix(result);
        if (prefix == null || prefix.equalsIgnoreCase("xmlns")) {
            return "";
        }
        return result;
    }

    public void setPrefix(String prefix) {
        this.getInstance().setPrefix(prefix);
    }

    public NodeImpl(nsIDOMEventTarget mozInst) {
        this.moz = (nsIDOMNode)mozInst.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
        instances.put(mozInst, this);
    }

    public boolean dispatchEvent(Event evt) {
        nsIDOMEvent mozEvt = ((EventImpl)evt).getInstance();
        boolean result = ((nsIDOMEventTarget)this.getInstance().queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}")).dispatchEvent(mozEvt);
        return result;
    }

    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        nsIDOMEventListener mozListener = ((EventListenerImpl)listener).getInstance();
        ((nsIDOMEventTarget)this.getInstance().queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}")).removeEventListener(type, mozListener, useCapture);
    }

    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        nsIDOMEventListener mozListener = ((EventListenerImpl)listener).getInstance();
        ((nsIDOMEventTarget)this.getInstance().queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}")).addEventListener(type, mozListener, useCapture);
    }
}

