

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;
import org.mozilla.dom.events.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;

public class NodeImpl implements org.w3c.dom.Node, org.w3c.dom.events.EventTarget
{
    protected nsIDOMNode moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();
    
    public static NodeImpl getDOMInstance(nsIDOMNode mozInst)
    {
        NodeImpl node = (NodeImpl) instances.get(mozInst);
        return node == null ? new NodeImpl(mozInst) : node;
    }
    
    public nsIDOMNode getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMNode) moz;
    }
    

/***************************************************************
 *                                                             *
 * Node implementation code            *
 *                                                             *
 ***************************************************************/
 
    public NodeImpl(nsIDOMNode mozInst)
    {
        moz = mozInst;
        instances.put(mozInst, this);
    }    
    public Node appendChild(Node newChild)
    {
        nsIDOMNode mozNewchild = ((NodeImpl) newChild).getInstance();
        nsIDOMNode result = getInstance().appendChild(mozNewchild);
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public String lookupPrefix(String namespaceURI)
    {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        String result = DOM3MozObject.lookupPrefix(namespaceURI);
            return result;
                }
    
    public void setNodeValue(String nodeValue)
    {
        getInstance().setNodeValue(nodeValue);
    }
    
    public boolean isSameNode(Node other)
    {
        nsIDOMNode mozOther = ((NodeImpl) other).getInstance();
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        boolean result = DOM3MozObject.isSameNode(mozOther);
            return result;
                }
    
    public Node cloneNode(boolean deep)
    {
        nsIDOMNode result = getInstance().cloneNode(deep);
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public Node getFirstChild()
    {
        nsIDOMNode current = getInstance();
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            if (SharedUtils.isFrameNode(current))
                return SharedUtils.frameNodeToDocument(current);
            else
                return (Node) NodeFactory.getNodeInstance(current.getFirstChild());
        } else {
                return (Node) NodeFactory.getNodeInstance(current.getFirstChild());
        }
}
    
    public void setTextContent(String textContent)
    {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        DOM3MozObject.setTextContent(textContent);
    }
    
    public boolean isEqualNode(Node arg)
    {
        nsIDOMNode mozArg = ((NodeImpl) arg).getInstance();
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        boolean result = DOM3MozObject.isEqualNode(mozArg);
            return result;
                }
    
    public void normalize()
    {
        getInstance().normalize();
    }
    
    public boolean isSupported(String feature, String version)
    {
        boolean result = getInstance().isSupported(feature, version);
        return result;
    }
    
    public Object getFeature(String feature, String version)
    {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        nsISupports result = DOM3MozObject.getFeature(feature, version);
            return result;
                }
    
    public Object getUserData(String key)
    {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        nsIVariant result = DOM3MozObject.getUserData(key);
            return result;
                }
    
    public String getPrefix()
    {
        String result = getInstance().getPrefix();
        return result;
    }
    
    public short getNodeType()
    {
        int result = getInstance().getNodeType();
        return (short) result;
    }
    
    public Node getNextSibling()
    {
        nsIDOMNode currentNode = getInstance();
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            if (SharedUtils.isHTMLNode(currentNode)) {
                inIDOMUtils utils = (inIDOMUtils)
                    Mozilla.getInstance().getServiceManager().getServiceByContractID(
                        "@mozilla.org/inspector/dom-utils;1",
                        inIDOMUtils.INIDOMUTILS_IID);
                nsIDOMNode parentNode = utils.getParentForNode(currentNode, false);

                if (parentNode!=null) return null;
            }

            nsIDOMNode result = currentNode.getNextSibling();
            return (Node) NodeFactory.getNodeInstance(result);
        } else {
            return (Node) NodeFactory.getNodeInstance(currentNode.getNextSibling());
        }
}
    
    public Node getLastChild()
    {
        nsIDOMNode current = getInstance();
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            if (SharedUtils.isFrameNode(current))
                return SharedUtils.frameNodeToDocument(current);
            else
                return (Node) NodeFactory.getNodeInstance(current.getLastChild());
        } else {
                return (Node) NodeFactory.getNodeInstance(current.getLastChild());
        }
}
    
    public boolean hasChildNodes()
    {
        nsIDOMNode current = getInstance();
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            if (SharedUtils.isFrameNode(current))
                return true;
            else
                return current.hasChildNodes();
        } else {
                return current.hasChildNodes();
        }
}
    
    public short compareDocumentPosition(Node other)
    {
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            Document startDoc1 = getOwnerDocument();
            Document startDoc2 = other.getOwnerDocument();
            if (startDoc1.isSameNode(startDoc2)) {
                //the standard case, inside of the same document
                nsIDOMNode mozOther = ((NodeImpl) other).getInstance();

                nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
                int result = DOM3MozObject.compareDocumentPosition(mozOther);
                return (short) result;
            } else {
                //find the common ancestor document and 
                //compare position of the ancestor frames

                Stack/*<Document>*/ docs1 = new Stack/*<Document>*/();
                {
                    Document d = startDoc1;
                    while (d!=null) {
                        docs1.push(d);
                        Node p = d.getParentNode();
                        if (p==null) d = null;
                        else d = p.getOwnerDocument();
                    }
                }
    
                Stack/*<Document>*/ docs2 = new Stack/*<Document>*/();
                {
                    Document d = startDoc2;
                    while (d!=null) {
                        docs2.push(d);
                        Node p = d.getParentNode();
                        if (p==null) d = null;
                        else d = p.getOwnerDocument();
                    }
                }
    
                Document lastCommon = null;
                Document doc1 = null;
                Document doc2 = null;
                while (!docs1.isEmpty() && !docs2.isEmpty()) {
                    doc1 = (Document) docs1.pop();
                    doc2 = (Document) docs2.pop();
                    if (doc1.isSameNode(doc2)) lastCommon = doc1;
                    else break;
                }
    
                if (lastCommon==null || doc1==null || doc2==null) {
                    //should not happen
                    return 33;
                }
    
                Node frame1 = doc1.getParentNode();
                if (frame1==null) {
                    if (docs1.isEmpty()) frame1 = this;
                    else frame1 = ((Document)docs1.peek()).getParentNode();
                }
                Node frame2 = doc2.getParentNode();
                if (frame2==null) {
                    if (docs2.isEmpty()) frame2 = other;
                    else frame2 = ((Document)docs2.peek()).getParentNode();
                }
                
                assert frame1!=null && frame2!=null;
                assert frame1.getOwnerDocument().isSameNode(frame2.getOwnerDocument());
    
                //compare position of the frames
                nsIDOM3Node mozFrame1 = (nsIDOM3Node) ((NodeImpl) frame1).getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
                nsIDOMNode mozFrame2 = ((NodeImpl) frame2).getInstance();
    
                int result = mozFrame1.compareDocumentPosition(mozFrame2);
                return (short) result;
            }
        } else {
            nsIDOMNode mozOther = ((NodeImpl) other).getInstance();

            nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
            int result = DOM3MozObject.compareDocumentPosition(mozOther);
            return (short) result;
        }
}
    
    public String getBaseURI()
    {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        String result = DOM3MozObject.getBaseURI();
            return result;
                }
    
    public boolean isDefaultNamespace(String namespaceURI)
    {
/* Not supported patch */
        throw new UnsupportedException();}
    
    public boolean hasAttributes()
    {
        boolean result = getInstance().hasAttributes();
        return result;
    }
    
    public Node insertBefore(Node newChild, Node refChild)
    {
        nsIDOMNode mozNewchild = ((NodeImpl) newChild).getInstance();
        nsIDOMNode mozRefchild = ((NodeImpl) refChild).getInstance();
        nsIDOMNode result = getInstance().insertBefore(mozNewchild, mozRefchild);
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public NodeList getChildNodes()
    {
        nsIDOMNode current = getInstance();
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            if (SharedUtils.isFrameNode(current))
                return new NodeListImpl(((NodeImpl)SharedUtils.frameNodeToDocument(current)).getInstance().getChildNodes());
            else
                return new NodeListImpl(current.getChildNodes());
        } else {
                return new NodeListImpl(current.getChildNodes());
        }
}
    
    public Node getParentNode()
    {
        nsIDOMNode currentNode = getInstance();
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            if (currentNode.getNodeType() == nsIDOMNode.DOCUMENT_NODE)
            {
                inIDOMUtils utils = (inIDOMUtils)
                    Mozilla.getInstance().getServiceManager().getServiceByContractID(
                        "@mozilla.org/inspector/dom-utils;1",
                         inIDOMUtils.INIDOMUTILS_IID);
                nsIDOMNode parentNode = utils.getParentForNode(currentNode, false);

                if (parentNode == null)
                    return null;
    
                return (Node) NodeFactory.getNodeInstance(parentNode);
            }
            else 
            {
                nsIDOMNode parentNode = getInstance().getParentNode();
                if (parentNode != null && parentNode.getNodeType() == nsIDOMNode.DOCUMENT_NODE)
                {
                    inIDOMUtils utils = (inIDOMUtils)
                        Mozilla.getInstance().getServiceManager().getServiceByContractID(
                           "@mozilla.org/inspector/dom-utils;1",
                            inIDOMUtils.INIDOMUTILS_IID);
                    nsIDOMNode parentParentNode = utils.getParentForNode(parentNode, false);

                    if (parentParentNode == null)
                        return (Node) NodeFactory.getNodeInstance(parentNode);

                    return (Node) NodeFactory.getNodeInstance(parentParentNode);    
                }
                else
                    return (Node) NodeFactory.getNodeInstance(parentNode);
            }
        } else {
            return (Node) NodeFactory.getNodeInstance(currentNode.getParentNode());
        }
}
    
    public String getNodeName()
    {
        String result = getInstance().getNodeName();
        /* Case insensitivity patch */
        if (NodeFactory.getConvertNodeNamesToLowerCase())
            return result.toLowerCase();
        else
            return result;
    }
    
    public Node getPreviousSibling()
    {
        nsIDOMNode currentNode = getInstance();
        if (NodeFactory.getExpandFrames()) {
            /* Frame patch */
            if (SharedUtils.isHTMLNode(currentNode)) {
                inIDOMUtils utils = (inIDOMUtils)
                    Mozilla.getInstance().getServiceManager().getServiceByContractID(
                        "@mozilla.org/inspector/dom-utils;1",
                        inIDOMUtils.INIDOMUTILS_IID);
                nsIDOMNode parentNode = utils.getParentForNode(currentNode, false);

                if (parentNode!=null) return null;
            }

            nsIDOMNode result = currentNode.getPreviousSibling();
            return (Node) NodeFactory.getNodeInstance(result);
        } else {
            return (Node) NodeFactory.getNodeInstance(currentNode.getPreviousSibling());
        }
}
    
    public Node replaceChild(Node newChild, Node oldChild)
    {
        nsIDOMNode mozNewchild = ((NodeImpl) newChild).getInstance();
        nsIDOMNode mozOldchild = ((NodeImpl) oldChild).getInstance();
        nsIDOMNode result = getInstance().replaceChild(mozNewchild, mozOldchild);
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public Document getOwnerDocument()
    {
        nsIDOMDocument result = getInstance().getOwnerDocument();
        return (Document) NodeFactory.getNodeInstance(result);
    }
    
    public String getLocalName()
    {
        String result = getInstance().getLocalName();
        /* Case insensitivity patch */
        if (NodeFactory.getConvertNodeNamesToLowerCase())
            return result.toLowerCase();
        else
            return result;
    }
    
    public Object setUserData(String key, Object data, UserDataHandler handler)
    {
        throw new UnsupportedException();
    }
    
    public String getTextContent()
    {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        String result = DOM3MozObject.getTextContent();
            return result;
                }
    
    public String lookupNamespaceURI(String prefix)
    {
        nsIDOM3Node DOM3MozObject = (nsIDOM3Node) getInstance().queryInterface(nsIDOM3Node.NS_IDOM3NODE_IID);
        String result = DOM3MozObject.lookupNamespaceURI(prefix);
            return result;
                }
    
    public String getNodeValue()
    {
        String result = getInstance().getNodeValue();
        return result;
    }
    
    public Node removeChild(Node oldChild)
    {
        nsIDOMNode mozOldchild = ((NodeImpl) oldChild).getInstance();
        nsIDOMNode result = getInstance().removeChild(mozOldchild);
        return (Node) NodeFactory.getNodeInstance(result);
    }
    
    public NamedNodeMap getAttributes()
    {
        nsIDOMNamedNodeMap result = getInstance().getAttributes();
        return new NamedNodeMapImpl(result);
    }
    
    public String getNamespaceURI()
    {
        String result = getInstance().getNamespaceURI();
        	/* Namespace insensitivity patch */
        if (result ==null)
            return "";
        else
        {
            String prefix = lookupPrefix(result);
            if (prefix==null || prefix.equalsIgnoreCase("xmlns"))
            return "";
        }                
        //System.out.println("----- isDefault: " + isDefaultNamespace(result));
        //System.out.println("----- lookUpPrefix: " + lookupPrefix(result));
        //System.out.println("----- lookUpNamespaceURI: " + lookupNamespaceURI(result));
        return result;

    }
    
    public void setPrefix(String prefix)
    {
        getInstance().setPrefix(prefix);
    }
    
/***************************************************************
 *                                                             *
 * EventTarget implementation code            *
 *                                                             *
 ***************************************************************/
 
    public NodeImpl(nsIDOMEventTarget mozInst)
    {
        moz = (nsIDOMNode) mozInst.queryInterface(nsIDOMNode.NS_IDOMNODE_IID);
        instances.put(mozInst, this);
    }    
    public boolean dispatchEvent(Event evt)
    {
        nsIDOMEvent mozEvt = ((EventImpl) evt).getInstance();
        boolean result = ((nsIDOMEventTarget) getInstance().queryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID)).dispatchEvent(mozEvt);
        return result;
    }
    
    public void removeEventListener(String type, org.w3c.dom.events.EventListener listener, boolean useCapture)
    {
        nsIDOMEventListener mozListener = ((EventListenerImpl) listener).getInstance();
        ((nsIDOMEventTarget) getInstance().queryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID)).removeEventListener(type, mozListener, useCapture);
    }
    
    public void addEventListener(String type, org.w3c.dom.events.EventListener listener, boolean useCapture)
    {
        nsIDOMEventListener mozListener = ((EventListenerImpl) listener).getInstance();
        ((nsIDOMEventTarget) getInstance().queryInterface(nsIDOMEventTarget.NS_IDOMEVENTTARGET_IID)).addEventListener(type, mozListener, useCapture);
    }
    
}
