

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozdom4java
 *
 * The Initial Developer of the Original Code is
 * Peter Szinek, Lixto Software GmbH, http://www.lixto.com.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Peter Szinek (peter@rubyrailways.com)
 *  Michal Ceresna (michal.ceresna@gmail.com)
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


package org.mozilla.dom.html;

//Java imports
import java.util.*;

//org.w3c imports
import org.w3c.dom.*;
import org.w3c.dom.html2.*;
import org.w3c.dom.html.*;
import org.w3c.dom.events.*;
import org.w3c.dom.traversal.*;
import org.w3c.dom.ranges.*;
import org.w3c.dom.views.*;

//mozdom4java imports
import org.mozilla.dom.*;
import org.mozilla.dom.views.*;

//XPCOM import
import org.mozilla.xpcom.*;
import org.mozilla.interfaces.*;


public class HTMLTableElementImpl extends HTMLElementImpl implements org.w3c.dom.html.HTMLTableElement
{
    protected HTMLTableElementImpl(nsIDOMHTMLTableElement mozInst)
    {
        super( mozInst );
    }

    public static HTMLTableElementImpl getDOMInstance(nsIDOMHTMLTableElement mozInst)
    {
        HTMLTableElementImpl node = (HTMLTableElementImpl) instances.get(mozInst);
        return node == null ? new HTMLTableElementImpl(mozInst) : node;
    }
    
    public nsIDOMHTMLTableElement getInstance()
    {
        //This was already queryinterfaced, so safe to cast
        return (nsIDOMHTMLTableElement) moz;
    }
    
    public void deleteTHead()
    {
        getInstance().deleteTHead();
    }
    
    public HTMLCollection getRows()
    {
        nsIDOMHTMLCollection result = getInstance().getRows();
        return new HTMLCollectionImpl(result);
    }
    
    public HTMLTableCaptionElement getCaption()
    {
        nsIDOMHTMLTableCaptionElement result = getInstance().getCaption();
        return (HTMLTableCaptionElement) NodeFactory.getNodeInstance(result);
    }
    
    public HTMLElement createCaption()
    {
        nsIDOMHTMLElement result = getInstance().createCaption();
        return (HTMLElement) NodeFactory.getNodeInstance(result);
    }
    
    public void setWidth(String width)
    {
        getInstance().setWidth(width);
    }
    
    public void setRules(String rules)
    {
        getInstance().setRules(rules);
    }
    
    public HTMLElement createTFoot()
    {
        nsIDOMHTMLElement result = getInstance().createTFoot();
        return (HTMLElement) NodeFactory.getNodeInstance(result);
    }
    
    public String getRules()
    {
        String result = getInstance().getRules();
        return result;
    }
    
    public String getFrame()
    {
        String result = getInstance().getFrame();
        return result;
    }
    
    public void deleteRow(int index)
    {
        getInstance().deleteRow(index);
    }
    
    public void setTHead(HTMLTableSectionElement tHead)
    {
        nsIDOMHTMLTableSectionElement mozThead = ((HTMLTableSectionElementImpl) tHead).getInstance();
        getInstance().setTHead(mozThead);
    }
    
    public void setTFoot(HTMLTableSectionElement tFoot)
    {
        nsIDOMHTMLTableSectionElement mozTfoot = ((HTMLTableSectionElementImpl) tFoot).getInstance();
        getInstance().setTFoot(mozTfoot);
    }
    
    public void setCellSpacing(String cellSpacing)
    {
        getInstance().setCellSpacing(cellSpacing);
    }
    
    public HTMLCollection getTBodies()
    {
        nsIDOMHTMLCollection result = getInstance().getTBodies();
        return new HTMLCollectionImpl(result);
    }
    
    public void setBgColor(String bgColor)
    {
        getInstance().setBgColor(bgColor);
    }
    
    public HTMLElement createTHead()
    {
        nsIDOMHTMLElement result = getInstance().createTHead();
        return (HTMLElement) NodeFactory.getNodeInstance(result);
    }
    
    public void setSummary(String summary)
    {
        getInstance().setSummary(summary);
    }
    
    public HTMLTableSectionElement getTHead()
    {
        nsIDOMHTMLTableSectionElement result = getInstance().getTHead();
        return (HTMLTableSectionElement) NodeFactory.getNodeInstance(result);
    }
    
    public void setAlign(String align)
    {
        getInstance().setAlign(align);
    }
    
    public HTMLTableSectionElement getTFoot()
    {
        nsIDOMHTMLTableSectionElement result = getInstance().getTFoot();
        return (HTMLTableSectionElement) NodeFactory.getNodeInstance(result);
    }
    
    public String getSummary()
    {
        String result = getInstance().getSummary();
        return result;
    }
    
    public String getAlign()
    {
        String result = getInstance().getAlign();
        return result;
    }
    
    public void setCaption(HTMLTableCaptionElement caption)
    {
        nsIDOMHTMLTableCaptionElement mozCaption = ((HTMLTableCaptionElementImpl) caption).getInstance();
        getInstance().setCaption(mozCaption);
    }
    
    public void deleteTFoot()
    {
        getInstance().deleteTFoot();
    }
    
    public String getWidth()
    {
        String result = getInstance().getWidth();
        return result;
    }
    
    public void setFrame(String frame)
    {
        getInstance().setFrame(frame);
    }
    
    public String getCellPadding()
    {
        String result = getInstance().getCellPadding();
        return result;
    }
    
    public String getBorder()
    {
        String result = getInstance().getBorder();
        return result;
    }
    
    public HTMLElement insertRow(int index)
    {
        nsIDOMHTMLElement result = getInstance().insertRow(index);
        return (HTMLElement) NodeFactory.getNodeInstance(result);
    }
    
    public void setBorder(String border)
    {
        getInstance().setBorder(border);
    }
    
    public void deleteCaption()
    {
        getInstance().deleteCaption();
    }
    
    public String getCellSpacing()
    {
        String result = getInstance().getCellSpacing();
        return result;
    }
    
    public String getBgColor()
    {
        String result = getInstance().getBgColor();
        return result;
    }
    
    public void setCellPadding(String cellPadding)
    {
        getInstance().setCellPadding(cellPadding);
    }
    
}
