#!/bin/bash

# string.bash --- string(3) ̺귯 bash ķ̼ 
# : Noah Friedman &lt;friedman@prep.ai.mit.edu&gt;
# ==>      Ͽ   .
# Created: 1992-07-01
# Last modified: 1993-09-29
# Public domain

# Chet Ramey  bash  2   ȯ

# Commentary:
# Code:

#:docstring strcat:
# Usage: strcat s1 s2
#
# Strcat  s2  s1  .
#
# :
#    a="foo"
#    b="bar"
#    strcat a b
#    echo $a
#    => foobar
#
#:end docstring:

###;;;autoload   ==> Autoloading of function commented out.
function strcat ()
{
    local s1_val s2_val

    s1_val=${!1}                        #   Ȯ
    s2_val=${!2}
    eval "$1"=\'"${s1_val}${s2_val}"\'
    # ==>   ϳ  ǥ   쿡,
    # ==> eval $1='${s1_val}${s2_val}' ̶ ϸ ˴ϴ.
}

#:docstring strncat:
# : strncat s1 s2 $n
# 
# strcat   s2  ִ n ڸŭ Դϴ. s2  n 
# ªٸ ׳ s2  մϴ. Echoes result on stdout.
#
# :
#    a=foo
#    b=barbaz
#    strncat a b 3
#    echo $a
#    => foobar
#
#:end docstring:

###;;;autoload
function strncat ()
{
    local s1="$1"
    local s2="$2"
    local -i n="$3"
    local s1_val s2_val

    s1_val=${!s1}                       # ==>    Ȯ
    s2_val=${!s2}

    if [ ${#s2_val} -gt ${n} ]; then
       s2_val=${s2_val:0:$n}            # ==> ڿ(substring) 
    fi

    eval "$s1"=\'"${s1_val}${s2_val}"\'
    # ==>   ϳ  ǥ   쿡,
    # ==> eval $1='${s1_val}${s2_val}' ̶ ϸ ˴ϴ.
}

#:docstring strcmp:
# : strcmp $s1 $s2
#
# Strcmp   ڸ   ؼ s1  s2   ,
#  0, ũ  մϴ.
#:end docstring:

###;;;autoload
function strcmp ()
{
    [ "$1" = "$2" ] && return 0

    [ "${1}" '<' "${2}" ] > /dev/null && return -1

    return 1
}

#:docstring strncmp:
# : strncmp $s1 $s2 $n
# 
# strcmp  ϳ ִ n ڸŭ մϴ( n  0 ϸ 0  ).
#:end docstring:

###;;;autoload
function strncmp ()
{
    if [ -z "${3}" -o "${3}" -le "0" ]; then
       return 0
    fi
   
    if [ ${3} -ge ${#1} -a ${3} -ge ${#2} ]; then
       strcmp "$1" "$2"
       return $?
    else
       s1=${1:0:$3}
       s2=${2:0:$3}
       strcmp $s1 $s2
       return $?
    fi
}

#:docstring strlen:
# : strlen s
#
# Strlen  s  ̸ մϴ.
#:end docstring:

###;;;autoload
function strlen ()
{
    eval echo "\${#${1}}"
    # ==> ڷ Ѿ  ̸ 
}

#:docstring strspn:
# : strspn $s1 $s2
# 
# Strspn  s2 ü ϴ s1  ִ ʱ ׸Ʈ ̸ մϴ.
#:end docstring:

###;;;autoload
function strspn ()
{
    # IFS    鹮ڵ Ϲ ó ó  ֽϴ.
    local IFS=
    local result="${1%%[!${2}]*}"
 
    echo ${#result}
}

#:docstring strcspn:
# : strcspn $s1 $s2
#
# Strcspn  s2 ü Ե ʴ s1  ִ ʱ ׸Ʈ ̸ մϴ.
#:end docstring:

###;;;autoload
function strcspn ()
{
    # IFS    鹮ڵ Ϲ ó ó  ֽϴ.
    local IFS=
    local result="${1%%[${2}]*}"
 
    echo ${#result}
}

#:docstring strstr:
# : strstr s1 s2
# 
# Strstr  s1  s2  ó ߰ߵǴ ڿ(substring)  ְ,
# s1  s2  ߰ߵ ʴ´ٸ ׳ մϴ. 
# ࿡ s2  ̰ 0  ڿ Ųٸ s1  մϴ.
#:end docstring:

###;;;autoload
function strstr ()
{
    # s2  Ű ڿ ̰ 0 ̶ s1  
    [ ${#2} -eq 0 ] && { echo "$1" ; return 0; }

    # s1  s2  ߰ߵ  ׳ 
    case "$1" in
    *$2*) ;;
    *) return 1;;
    esac

    # ġϴ κк      Ī 
    first=${1/$2*/}

    #   ġ ù° κ 
    echo "${1##$first}"
}

#:docstring strtok:
# : strtok s1 s2
#
# Strtok  s1   s2   ִ ϳ ̻ ڿ  
# 0  ̻ ̷ ִٰ մϴ. 
# strtok  ó Ҹ(   s1  ؼ) ù° ū 
# ڿ ǥ  ݴϴ.  Լ ù° ڰ  ڿ 
#  ȣǵ ؼ ٷ  󳪿 ū óϵ ϱ ؼ
# ȣø s1  ڽ ġ  մϴ.
# ̷  ؼ   ȣ  ̻ ū   s1  óմϴ.
#  ڿ s2  ȣø ٸ  ֽϴ. s1  ó ū 
#   ʴٸ,   ǥ ڵ˴ϴ.

###;;;autoload
function strtok ()
{
 :
}

#:docstring strtrunc:
# : strtrunc $n $s1 {$s2} {$...}
# strncmp ó  Լ ̴µ, 񱳸 ؼ ڸ ߶ϴ. 
#  s1, s2 ...  ó n  ڸ ǥ  ݴϴ.
#:end docstring:

###;;;autoload
function strtrunc ()
{
    n=$1 ; shift
    for z; do
        echo "${z:0:$n}"
    done
}

# provide string

# string.bash  


# ========================================================================== #
# ==> ʹ   ڰ ߰ κԴϴ.

# ==>  ũƮ  ũƮ     
# ==>  ũƮ  ũƮ "source" ϸ˴ϴ.

# strcat
string0=one
string1=two
echo
echo "\"strcat\" Լ ׽Ʈ:"
echo " \"string0\" = $string0"
echo "\"string1\" = $string1"
strcat string0 string1
echo " \"string0\" = $string0"
echo

# strlen
echo
echo "\"strlen\" Լ ׽Ʈ:"
str=123456789
echo "\"str\" = $str"
echo -n "\"str\"   = "
strlen str
echo



# ڵ  :
# ⼭ Ұ ڿ Լ  ׽Ʈϴ ڵ带 ۼ .


exit 0
