
// Autor: Antonio Castro


#include "colors.inc"
#include "textures.inc"
#include "glass.inc"


#declare LugarLuz = <0, 15, 10>

#declare FASE = 1

#declare Mar = texture {
  pigment { color SeaGreen }
  normal { 
  ripples 0.2
  frequency 500.0
  phase  clock*FASE
  }
  finish { 
  ambient 0.1
  diffuse 0.1
  reflection 0.8
  specular 0.5
  }
  scale <3000, 3000, 3000>
 }


// La camara mirara al punto de contacto
// de ambas esferas
camera {
  location <-15, 15, 40>
  look_at <0, 3, 0>
}

// Fuente de luz blanca
object {
  light_source {
  LugarLuz
//  <20, 100, 50>
  color White
  }
}

sphere { <0, 15, 0> 2 
	pigment { White }
}

torus { 3, 0.5        // major and minor radius
    pigment { Yellow }
    finish { ambient 0.3 diffuse 0.7 }
    rotate -90*x      // so we can see it from the top
    translate LugarLuz
}



// Cielo con nubes blancas
object {
 sphere { <0, 0, 0> 200000}  // Boveda celeste de gran tamao
 texture {Blue_Sky scale <50000, 6000, 50000>} // Estiramos las nubes
 finish { ambient 0.4  diffuse 0.6 }
}


// Suelo 
sphere {<0, -1000000, 0> 1000000
 pigment {checker color Red color Yellow scale 2 } // Textura ajedrez
 finish { ambient 0.5   diffuse 0.5 }
}

//  Mar
sphere {<0, -1000000, 0> 1000006
     texture { Mar }
     clipped_by { sphere {<0, 0, -1000000> 1000000} }
}
   

box { <0, 0, 20>, <2, 6, 22>
     pigment { White }
     finish {
	ambient 0
	diffuse 1
	reflection 0
     }
}

box { <4, 0, 20>, <6, 6, 22>
     pigment { White }
     finish {
         ambient 0.5
         diffuse 0.5
	 reflection 0
     }
     no_shadow
}

box { <8, 0, 20>, <10, 6, 22>
     pigment { White }
     finish {
	ambient 0
	diffuse 1
	reflection 0
     }
}


sphere { <-10, 5, 17> 5
	texture { Glass }
        clipped_by {  sphere { <-15,5, 20>,4  inverse }  }
   translate < 2, 0, 2>
}

cylinder { 
   <-3, 6, 17> , < -21, 6, 17>, 1
  pigment { Grey }

 pigment { 
     leopard color_map {
         [0.0 color Black]
         [0.1 color Green ]
         [0.3 color Yellow ]
         [0.4 color White ]
         [0.7 color Blue ]
         [0.9 color Black ]
     }   
     scale 0.1
  }
   translate < 2, 0, 2>
}
