import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.*;


class DemoAppPanel extends JPanel
{

    // Possible Look & Feels
    private static final String mac      =
            "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String metal    =
            "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String motif    =
            "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String windows  =
            "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String gtk  =
            "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";


	JPanel panelEmpty;

	public DemoAppPanel()
	{
		try 
		{
			UIManager.setLookAndFeel(metal);
		} 
		catch (Exception ex) 
		{
		}
	

		/* set Layout */
		setLayout(new BorderLayout());

		/* add menu bar */
		JPanel menuPanel = new JPanel();
		menuPanel.setLayout(new BorderLayout());

		JMenuBar menuBar = new JMenuBar();
		menuBar.add(createFileMenu());
		menuBar.add(createDemoMenu());
		menuBar.add(createLFMenu());
		menuBar.add(createHelpMenu());
		menuPanel.add(menuBar, BorderLayout.NORTH);

		add(menuPanel, BorderLayout.NORTH);

		/* main window */
		panelEmpty = new EmptyPanel();

		panelEmpty.setPreferredSize(new Dimension(450, 250)); 
		add(panelEmpty, BorderLayout.CENTER);

		/* add status bar */
		JTextField statusField = new JTextField("Status field.");
		statusField.setEditable(false);
		add(statusField, BorderLayout.SOUTH);
	}


	private JMenu createFileMenu()
	{
		JMenu menu = new JMenu("File");
		JMenuItem menuItem;

		menuItem = new JMenuItem("Quit", 'Q');
		menu.add(menuItem);

		return menu;
	}	
  

	private JMenu createDemoMenu()
	{
		JMenu menu = new JMenu("Demo");
		JMenuItem menuItem;
		Action action;

		menuItem = new JMenuItem("Show DemoDlg", 'D');
		action = new ShowDemoDlgAction();
		menuItem.addActionListener(action);
		menu.add(menuItem);

		return menu;
	}

	private JMenu createHelpMenu()
	{
		JMenu menu = new JMenu("Help");
		JMenuItem menuItem;

		/* Context */
		menuItem = new JMenuItem("Context", 'C');
		menu.add(menuItem);

		menu.addSeparator();

		/* About */
		menuItem = new JMenuItem("About", 'A');
		menu.add(menuItem);

		return menu;
	}

	private JMenu createLFMenu()
	{
		JMenu menu = new JMenu("Look & Feel");
		JMenuItem menuItem;

		/* Java */
		menuItem = new JMenuItem("Java", 'J');
		menu.add(menuItem);

		/* Motif */
		menuItem = new JMenuItem("Motif", 'M');
		menu.add(menuItem);

		/* GTK */
		menuItem = new JMenuItem("GTK", 'G');
		menu.add(menuItem);

		/* Windows */
		menuItem = new JMenuItem("Windows", 'W');
		menu.add(menuItem);

		return menu;
	}


	/* show demo dialog */
    class ShowDemoDlgAction extends AbstractAction 
	{

		ShowDemoDlgAction() 
		{
		}

		ShowDemoDlgAction(String str) 
		{
			super(str);
		}

        public void actionPerformed(ActionEvent e) 
		{
			JFrame frame = new JFrame();
		
			frame.setTitle("DemoDlg");
			frame.getContentPane().add(new DemoDlgPanel());
			frame.pack();
			frame.show();
		}

    }

}
