import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.net.*;
import java.io.*;
import javax.swing.border.*;


class DemoDlgPanel extends JPanel 
{
	public DemoDlgPanel() 
	{
		setLayout(new BorderLayout());

		JPanel controls = new ControlDemo(); 
		add(controls, BorderLayout.CENTER); 

		JPanel buttons = new ControlButtons();
		add(buttons, BorderLayout.SOUTH);
	}


	class ControlButtons extends JPanel
	{
		public ControlButtons()
		{
			setLayout(new FlowLayout());

			JButton button1 = new JButton("Cancel");
			add(button1);

			JButton button2 = new JButton("Apply");
			add(button2);
		}
	}


	class ControlDemo extends JPanel
	{
		public ControlDemo()
		{
			setLayout(new GridLayout(1,2));

			JPanel left = new LeftGroup();
			add(left);

			JPanel right = new RightGroup();
			add(right);
		}
	}

	class LeftGroup extends JPanel
	{
		ButtonGroup radiogroup = new ButtonGroup();

		public LeftGroup()
		{
			setLayout(new GridLayout(6,1));
			setBorder(new TitledBorder("Group"));

			JLabel label = new JLabel("Simple Text");
			JRadioButton radio1 = new JRadioButton("Radio1");
			JRadioButton radio2 = new JRadioButton("Radio1");
			JCheckBox check1 = new JCheckBox("Check1");
			JCheckBox check2 = new JCheckBox("Check2");
			JCheckBox check3 = new JCheckBox("Check3");

			add(label);

			add(radio1);
			radiogroup.add(radio1);

			add(radio2);
			radiogroup.add(radio2);

			add(check1);
			add(check2);
			add(check3);
		}
	}


	class RightGroup extends JPanel
	{
	   private String[] strTools = 
	   {
			"Java", "Qt", "wxWidgets"
		};

		public RightGroup()
		{
			setLayout(new GridLayout(6,1));
			setBorder(new TitledBorder("Group"));


			JLabel label1 = new JLabel("Input:");
			JTextField field = new JTextField("Test");

			add(label1);
			add(field);

			JLabel label2 = new JLabel("Choice:");
			JComboBox combo = new JComboBox(strTools);

			add(label2);
			add(combo);

			JLabel label3 = new JLabel("Progress");
			JProgressBar progress = new JProgressBar(JProgressBar.HORIZONTAL, 0, 100);
			progress.setValue(75);

			add(label3);
			add(progress);
		}
	}

}
