/******************************************************************************
 JXChoosePathDialog.h

	Interface for the JXChoosePathDialog class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXChoosePathDialog
#define _H_JXChoosePathDialog

#include <JXCSFDialogBase.h>

class JXChoosePathDialog : public JXCSFDialogBase
{
public:

	JXChoosePathDialog(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
					   const JCharacter* fileFilter,
					   const JBoolean selectOnlyWritable);

	virtual ~JXChoosePathDialog();

	void	BuildWindow(const JCharacter* message = NULL);

protected:

	void	SetObjects(JXScrollbarSet* scrollbarSet,
					   JXStaticText* pathLabel, JXPathInput* pathInput,
					   JXPathHistoryMenu* pathHistory,
					   JXStaticText* filterLabel, JXInputField* filterInput,
					   JXStringHistoryMenu* filterHistory,
					   JXTextButton* openButton, JXTextButton* selectButton,
					   JXTextButton* cancelButton,
					   JXTextButton* upButton, JXTextButton* homeButton,
					   JXNewDirButton* newDirButton, JXTextCheckbox* showHiddenCB,
					   const JCharacter* message);

	virtual void	UpdateDisplay();	// must call inherited

	virtual JBoolean	OKToDeactivate();
	virtual void		Receive(JBroadcaster* sender, const Message& message);

private:

	const JBoolean	itsSelectOnlyWritableFlag;

// begin JXLayout

    JXTextButton* itsOpenButton;
    JXTextButton* itsSelectButton;

// end JXLayout

private:

	// not allowed

	JXChoosePathDialog(const JXChoosePathDialog& source);
	const JXChoosePathDialog& operator=(const JXChoosePathDialog& source);
};

#endif
