/* -*- C++ -*- */
// FIFO_Send_Msg.h,v 4.8 1999/07/05 09:52:52 nanbor Exp

// ============================================================================
//
// = LIBRARY
//    ace
//
// = FILENAME
//    FIFO_Send_Msg.h
//
// = AUTHOR
//    Doug Schmidt
//
// ============================================================================

#ifndef ACE_FIFO_SEND_MSG_H
#define ACE_FIFO_SEND_MSG_H

#include "ace/FIFO_Send.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class ACE_Export ACE_FIFO_Send_Msg : public ACE_FIFO_Send
{
  // = TITLE
  //     Sender side for the Record oriented C++ wrapper for UNIX
  //     FIFOs.
public:
  // = Initialization methods.
  ACE_FIFO_Send_Msg (void);
  // Default constructor.

  ACE_FIFO_Send_Msg (const ASYS_TCHAR *rendezvous,
                     int flags = O_WRONLY,
                     int perms = ACE_DEFAULT_FILE_PERMS,
                     LPSECURITY_ATTRIBUTES sa = 0);
  // Open up a record-oriented named pipe for writing.

  int open (const ASYS_TCHAR *rendezvous,
            int flags = O_WRONLY,
            int perms = ACE_DEFAULT_FILE_PERMS,
            LPSECURITY_ATTRIBUTES sa = 0);
  // Open up a record-oriented named pipe for writing.

  ssize_t send (const ACE_Str_Buf &msg);
  // Send <buf> of up to <len> bytes.

  ssize_t send (const void *buf, size_t len);
  // Send <buf> of exactly <len> bytes (block until done).

#if defined (ACE_HAS_STREAM_PIPES)
  ssize_t send (const ACE_Str_Buf *data,
                const ACE_Str_Buf *cntl = 0,
                int flags = 0);
  // Send <data> and <cntl> message via Stream pipes.

  ssize_t send (int band,
                const ACE_Str_Buf *data,
                const ACE_Str_Buf *cntl = 0,
                int flags = MSG_BAND);
  // Send <data> and <cntl> message via Stream pipes in "band" mode.
#endif /* ACE_HAS_STREAM_PIPES */

  void dump (void) const;
  // Dump the state of an object.

  ACE_ALLOC_HOOK_DECLARE;
  // Declare the dynamic allocation hooks.
};

#if !defined (ACE_LACKS_INLINE_FUNCTIONS)
#include "ace/FIFO_Send_Msg.i"
#endif

#endif /* ACE_FIFO_SEND_MSG_H */
