/******************************************************************************
 JFloatBufferTableData.h

	Interface for the JFloatBufferTableData Class

	Copyright  1996 John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JFloatBufferTableData
#define _H_JFloatBufferTableData

#include <JStringTableData.h>

class JFloatTableData;

class JFloatBufferTableData : public JStringTableData
{
public:

	JFloatBufferTableData(const JFloatTableData* floatData,
						  const int precision);

	virtual ~JFloatBufferTableData();

protected:

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	const JFloatTableData*	itsFloatData;
	const int				itsPrecision;

private:

	void	UpdateCell(const JPoint& cell);
	void	UpdateRow(const JIndex rowIndex);
	void	UpdateCol(const JIndex colIndex);
	void	UpdateRect(const JRect& r);

	// not allowed

	JFloatBufferTableData(const JFloatBufferTableData& source);
	const JFloatBufferTableData& operator=(const JFloatBufferTableData& source);
};

#endif
