/******************************************************************************
 JFontStyle.h

	Style information for drawing text.

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JFontStyle
#define _H_JFontStyle

#include <jTypes.h>
#include <jColor.h>

typedef unsigned long	JFontID;

const JSize kJDefaultFontSize = 12;

struct JFontStyle
{
private:

	static JColorIndex itsDefaultColorIndex;

public:

	JBoolean			bold;
	JBoolean			italic;
	JSize				underlineCount;		// may change font height
	JBoolean			strike;
	JColorIndex			color;

	JFontStyle()
		:
		bold(kFalse),
		italic(kFalse),
		underlineCount(0),
		strike(kFalse),
		color(itsDefaultColorIndex)
	{ };

	JFontStyle
		(
		const JBoolean		b,
		const JBoolean		i,
		const JSize			u,
		const JBoolean		s,
		const JColorIndex	c = JFontStyle::itsDefaultColorIndex
		)
		:
		bold(b),
		italic(i),
		underlineCount(u),
		strike(s),
		color(c)
	{ };

	JFontStyle
		(
		const JColorIndex c
		)
		:
		bold(kFalse),
		italic(kFalse),
		underlineCount(0),
		strike(kFalse),
		color(c)
	{ };

	static void
	SetDefaultColorIndex
		(
		const JColorIndex c
		)
	{
		itsDefaultColorIndex = c;
	};
};

int operator==(const JFontStyle& s1, const JFontStyle& s2);

inline int
operator!=
	(
	const JFontStyle& s1,
	const JFontStyle& s2
	)
{
	return !(s1 == s2);
}

#endif
