/******************************************************************************
 JIPCError.cc

	Socket error messages.

	Copyright  1997 by Dustin Laurence. All rights reserved.

 *****************************************************************************/

#include <JIPCError.h>

const JCharacter* kJUnknownHost    = "JUnknownHost";
const JCharacter* kJUnknownHostMsg =
	"The nameserver has no information about that host.";

const JCharacter* kJNoIPAddress    = "JNoIPAddress";
const JCharacter* kJNoIPAddressMsg =
	"The given host name exists but has no IP address.";

const JCharacter* kJTemporaryNameserver    = "JTemporaryNameserver";
const JCharacter* kJTemporaryNameserverMsg =
	"A temporary nameserver error occured.  It may fix itself soon.";

const JCharacter* kJFatalNameserver    = "JFatalNameserver";
const JCharacter* kJFatalNameserverMsg =
	"A fatal nameserver error occured.  It isn't likely to fix itself.";

const JCharacter* kJConnectError    = "JConnectError";
const JCharacter* kJConnectErrorMsg =
	"An error occured in a call to connect().  Look at the kernel code if you want details.";

const JCharacter* kJNotASocket    = "JNotASocket";
const JCharacter* kJNotASocketMsg =
	"The descriptor is not a socket.";

const JCharacter* kJSocketCannotListen    = "JSocketCannotListen";
const JCharacter* kJSocketCannotListenMsg =
	"The socket is of a type which does not support listen.";

const JCharacter* kJSocketCannotAccept    = "JSocketCannotAccept";
const JCharacter* kJSocketCannotAcceptMsg =
	"The socket is of a type which does not support accept.";

const JCharacter* kJSocketClosed    = "JSocketClosed";
const JCharacter* kJSocketClosedMsg =
	"The socket or pipe was closed at the other end.";

const JCharacter* kJAddressInUse    = "JAddressInUse";
const JCharacter* kJAddressInUseMsg =
	"The given address could not be bound because it is already in use";

const JCharacter* kJSocketAlreadyBound    = "JSocketAlreadyBound";
const JCharacter* kJSocketAlreadyBoundMsg =
	"The socket is already bound to an address and cannot be bound again.";

const JCharacter* kJProtectedAddress    = "JProtectedAddress";
const JCharacter* kJProtectedAddressMsg =
	"A bind to a protected address was attempted without superuser permissions.";

const JCharacter* kJSocketDoesNotExist    = "JSocketDoesNotExist";
const JCharacter* kJSocketDoesNotExistMsg =
	"An attempt was made to connect to a unix domain socket which does not exist.";
