#ifndef _H_jRand
#define _H_jRand

/******************************************************************************
 jRand.h

	Interface for the jRand library.

	Copyright  1997 by Dustin Laurence.  All rights reserved.
	
	Base code generated by Codemill v0.1.0

 *****************************************************************************/

#include <jTypes.h>

/******************************************************************************
 JKLRandInt32

 ******************************************************************************/

inline JInt32
JKLRandInt32
	(
	const JInt32 seed
	)
{
	return 1664525L*seed + 1013904223L;
}

#ifdef JInt64_EXISTS
/******************************************************************************
 JKHRandInt64

 ******************************************************************************/

inline JInt64
JKHRandInt64
	(
	const JInt64 seed
	)
{
	return 6364136223846793005L*seed + 1L;
}
#endif

/******************************************************************************
 JRandWord

 ******************************************************************************/

inline JWord
JRandWord
	(
	const JWord seed
	)
{
#if JWORDSIZE == 8

	#ifndef JInt64_EXISTS

		*** We dont have a word-sized variable available!

	#endif

	return JKHRandInt64(seed);

#elif JWORDSIZE == 4

	// We always have a 32-bit quantity

	return JKLRandInt32(seed);

#else

	*** We dont have a word-sized generator available!

#endif
}


#endif
