/******************************************************************************
 JXUNDialogBase.cc

	BASE CLASS = JXDialogDirector

	Copyright  1998 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXUNDialogBase.h>
#include <JXWindow.h>
#include <JXStaticText.h>
#include <JXImageWidget.h>
#include <JXImage.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXUNDialogBase::JXUNDialogBase
	(
	JXDirector* supervisor
	)
	:
	JXDialogDirector(supervisor, kFalse)
{
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXUNDialogBase::~JXUNDialogBase()
{
}

/******************************************************************************
 Init (protected)

 ******************************************************************************/

void
JXUNDialogBase::Init
	(
	JXWindow*			window,
	JXStaticText*		text,
	const JCharacter*	message,
	JXImageWidget*		icon,
	const JXPM&			xpm
	)
{
	text->SetText(message);

	// adjust window size to fit text

	const JRect apG = text->GetApertureGlobal();

	JSize dw          = 0;
	const JSize prefw = text->TEGetMinPreferredGUIWidth();
	const JSize apw   = apG.width();
	if (prefw > apw)
		{
		dw = prefw - apw;
		}

	JSize dh        = 0;
	const JSize bdh = text->GetBoundsHeight();
	const JSize aph = apG.height();
	if (bdh > aph)
		{
		dh = bdh - aph;
		}

	window->AdjustSize(dw, dh);
	window->LockCurrentSize();
	window->PlaceAsDialogWindow();

	// display the icon

	JXImage* image = new JXImage(GetDisplay(), window->GetColormap(), xpm);
	assert( image != NULL );
	image->SetDefaultState(JXImage::kRemoteStorage);
	image->ConvertToDefaultState();
	icon->SetImage(image, kTrue);
}
