/******************************************************************************
 TestSaveFileDialog.h

	Interface for the TestSaveFileDialog class

	Written by John Lindal.

 ******************************************************************************/

#ifndef _H_TestSaveFileDialog
#define _H_TestSaveFileDialog

#include <JXSaveFileDialog.h>
#include "TestChooseSaveFile.h"		// need definition of SaveFormat

class JXRadioGroup;

class TestSaveFileDialog : public JXSaveFileDialog
{
public:

	TestSaveFileDialog(JXDirector* supervisor, JUNIXDirInfo* dirInfo,
					   const JCharacter* fileFilter,
					   const TestChooseSaveFile::SaveFormat saveFormat);

	virtual ~TestSaveFileDialog();

	void	BuildWindow(const JCharacter* origName, const JCharacter* prompt,
						const JCharacter* message = NULL);

	TestChooseSaveFile::SaveFormat	GetSaveFormat() const;

protected:

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	TestChooseSaveFile::SaveFormat	itsSaveFormat;

// begin JXLayout

    JXRadioGroup* itsFormatRG;

// end JXLayout

private:

	void	HandleFormatChange(const JIndex id);

	// not allowed

	TestSaveFileDialog(const TestSaveFileDialog& source);
	const TestSaveFileDialog& operator=(const TestSaveFileDialog& source);
};

#endif
