/* $Id: RowColumn.h,v 1.1.1.1 2001/04/09 13:33:07 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_rowcolumn_h)
#define xarm_rowcolumn_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>
#include <Xm/RowColumn.h>

class RowColumnClass : public ManagerClass {
 protected:
   RowColumnClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer() { return xmRowColumnWidgetClass; }
   virtual _XtString className() { return (_XtString) "XmRowColumn"; }
 public:
   /* callbacks */
   void entryCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNentryCallback); }
   void mapCallback(XtCallbackProc fp, XtPointer data = NULL)   { XARM_SET_CALLBACK(XmNmapCallback); }
   void tearOffMenuActivateCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                  { XARM_SET_CALLBACK(XmNtearOffMenuActivateCallback); }
   void tearOffMenuDeactivateCallback(XtCallbackProc fp, XtPointer data = NULL)
                                                { XARM_SET_CALLBACK(XmNtearOffMenuDeactivateCallback); }
   void unmapCallback(XtCallbackProc fp, XtPointer data = NULL) { XARM_SET_CALLBACK(XmNunmapCallback); }

   /* resources */
   void adjustLast(Boolean val)                    { XARM_SET_VALUE(XmNadjustLast); }
   Boolean adjustLast() const                      { XARM_GET_VALUE(Boolean, XmNadjustLast); }
   void adjustMargin(Boolean val)                  { XARM_SET_VALUE(XmNadjustMargin); }
   Boolean adjustMargin() const                    { XARM_GET_VALUE(Boolean, XmNadjustMargin); }
   void entryAlignment(unsigned char val)          { XARM_SET_VALUE(XmNentryAlignment); }
   unsigned char entryAlignment() const            { XARM_GET_VALUE(unsigned char, XmNentryAlignment); }
   void entryBorder(Dimension val)                 { XARM_SET_VALUE(XmNentryBorder); }
   Dimension entryBorder() const                   { XARM_GET_VALUE(Dimension, XmNentryBorder); }
   void entryClass(WidgetClass val)                { XARM_SET_VALUE(XmNentryClass); }
   WidgetClass entryClass() const                  { XARM_GET_VALUE(WidgetClass, XmNentryClass); }
   void entryVerticalAlignment(unsigned char val)  { XARM_SET_VALUE(XmNentryVerticalAlignment); }
   unsigned char entryVerticalAlignment() const 
                                      { XARM_GET_VALUE(unsigned char, XmNentryVerticalAlignment); }
   void isAligned(Boolean val)                     { XARM_SET_VALUE(XmNisAligned); }
   Boolean isAligned() const                       { XARM_GET_VALUE(Boolean, XmNisAligned); }
   void isHomogeneous(Boolean val)                 { XARM_SET_VALUE(XmNisHomogeneous); }
   Boolean isHomogeneous() const                   { XARM_GET_VALUE(Boolean, XmNisHomogeneous); }
   void marginHeight(Dimension val)                { XARM_SET_VALUE(XmNmarginHeight); }
   Dimension marginHeight() const                  { XARM_GET_VALUE(Dimension, XmNmarginHeight); }
   void marginWidth(Dimension val)                 { XARM_SET_VALUE(XmNmarginWidth); }
   Dimension marginWidth() const                   { XARM_GET_VALUE(Dimension, XmNmarginWidth); }
   void menuAccelerator(const _XtString val)       { XARM_SET_VALUE(XmNmenuAccelerator); }
   _XtString menuAccelerator() const               { XARM_GET_VALUE(_XtString, XmNmenuAccelerator); }
   void menuHelpWidget(Widget val)                 { XARM_SET_VALUE(XmNmenuHelpWidget); }
   Widget menuHelpWidget() const                   { XARM_GET_VALUE(Widget, XmNmenuHelpWidget); }
   void menuHistory(Widget val)                    { XARM_SET_VALUE(XmNmenuHistory); }
   Widget menuHistory() const                      { XARM_GET_VALUE(Widget, XmNmenuHistory); }
   void menuPost(const _XtString val)              { XARM_SET_VALUE(XmNmenuPost); }
   _XtString menuPost() const                      { XARM_GET_VALUE(_XtString, XmNmenuPost); }
   void mnemonic(KeySym val)                       { XARM_SET_VALUE(XmNmnemonic); }
   KeySym mnemonic() const                         { XARM_GET_VALUE(KeySym, XmNmnemonic); }
   void mnemonicCharSet(const _XtString val)       { XARM_SET_VALUE(XmNmnemonicCharSet); }
   _XtString mnemonicCharSet() const               { XARM_GET_VALUE(_XtString, XmNmnemonicCharSet); }
   void numColumns(short val)                      { XARM_SET_VALUE(XmNnumColumns); }
   short numColumns() const                        { XARM_GET_VALUE(short, XmNnumColumns); }
   void orientation(unsigned char val)             { XARM_SET_VALUE(XmNorientation); }
   unsigned char orientation() const               { XARM_GET_VALUE(unsigned char, XmNorientation); }
   void packing(unsigned char val)                 { XARM_SET_VALUE(XmNpacking); }
   unsigned char packing() const                   { XARM_GET_VALUE(unsigned char, XmNpacking); }
   void popupEnabled(Boolean val)                  { XARM_SET_VALUE(XmNpopupEnabled); }
   Boolean popupEnabled() const                    { XARM_GET_VALUE(Boolean, XmNpopupEnabled); }
   void radioAlwaysOne(Boolean val)                { XARM_SET_VALUE(XmNradioAlwaysOne); }
   Boolean radioAlwaysOne() const                  { XARM_GET_VALUE(Boolean, XmNradioAlwaysOne); }
   void radioBehavior(Boolean val)                 { XARM_SET_VALUE(XmNradioBehavior); }
   Boolean radioBehavior() const                   { XARM_GET_VALUE(Boolean, XmNradioBehavior); }
   void resizeHeight(Boolean val)                  { XARM_SET_VALUE(XmNresizeHeight); }
   Boolean resizeHeight() const                    { XARM_GET_VALUE(Boolean, XmNresizeHeight); }
   void resizeWidth(Boolean val)                   { XARM_SET_VALUE(XmNresizeWidth); }
   Boolean resizeWidth() const                     { XARM_GET_VALUE(Boolean, XmNresizeWidth); }
   unsigned char rowColumnType() const             { XARM_GET_VALUE(unsigned char, XmNrowColumnType); }
   void spacing(Dimension val)                     { XARM_SET_VALUE(XmNspacing); }
   Dimension spacing() const                       { XARM_GET_VALUE(Dimension, XmNspacing); }
   void subMenuId(Widget val)                      { XARM_SET_VALUE(XmNsubMenuId); }
   Widget subMenuId() const                        { XARM_GET_VALUE(Widget, XmNsubMenuId); }
   void tearOffModel(unsigned char val)            { XARM_SET_VALUE(XmNtearOffModel); }
   unsigned char tearOffModel() const              { XARM_GET_VALUE(unsigned char, XmNtearOffModel); }
   void whichButton(unsigned int val)              { XARM_SET_VALUE(XmNwhichButton); }
   unsigned int whichButton() const                { XARM_GET_VALUE(unsigned int, XmNwhichButton); }
};


class PulldownMenuClass : public RowColumnClass {
 protected:
   PulldownMenuClass() {} /* only a derived class can make this */
};


class MenuBarClass : public RowColumnClass {
 protected:
   MenuBarClass() {} /* only a derived class can make this */
 public:
   /* extra functionality */
   void help(Widget pull);
   void help(PulldownMenuClass *pull) { help(pull->widget()); }
};

class OptionMenuClass : public RowColumnClass {
 protected:
   OptionMenuClass() {} /* only a derived class can make this */
 public:
   void  labelString(XmString val)    { XARM_SET_VALUE(XmNlabelString); }
   void  labelString(const char *str) { XARM_SET_STRING(XmNlabelString); }
   char *labelString()                { XARM_GET_STRING(XmNlabelString); }
};

class PopupMenuClass : public RowColumnClass {
 protected:
   PopupMenuClass() {} /* only a derived class can make this */
};

class RadioBoxClass : public RowColumnClass {
 protected:
   RadioBoxClass() {} /* only a derived class can make this */
};

class CheckBoxClass : public RowColumnClass {
 protected:
   CheckBoxClass() {}
};


typedef XarmFuncWidget<RowColumnClass,    XmCreateRowColumn,        false>  RowColumn;
typedef XarmFuncWidget<PulldownMenuClass, XmCreatePulldownMenu,     false>  PulldownMenu;
typedef XarmFuncWidget<MenuBarClass,      XmCreateMenuBar,          false>  MenuBar;
typedef XarmFuncWidget<OptionMenuClass,   XmCreateOptionMenu,       false>  OptionMenu;
typedef XarmFuncWidget<OptionMenuClass,   XmCreateSimpleOptionMenu, false>  SimpleOptionMenu;
typedef XarmFuncWidget<PopupMenuClass,    XmCreatePopupMenu,        false>  PopupMenu;
typedef XarmFuncWidget<RadioBoxClass,     XmCreateRadioBox,         false>  RadioBox;
typedef XarmFuncWidget<CheckBoxClass,     XmCreateSimpleCheckBox,   false>  CheckBox;


#endif
