/* $Id: ScrolledW.h,v 1.1.1.1 2001/04/09 13:33:13 glgay Exp $ */
/*
 Copyright (C) 1993, 1994 Jettero Heller
 Copyright (C) 1994, 1995 Peter Williams
 Copyright (C) 1999       Gerald L. Gay
 
 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public License 
 version 2 as published by the Free Software Foundation.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; see the file COPYING.  If not,
 write to the Free Software Foundation, Inc., 675 Mass Ave, 
 Cambridge, MA 02139, USA.
*/


#if !defined(xarm_scrolledw_h)
#define xarm_scrolledw_h

/* ======================================================================= */
/* Include(s): */
#include <Xarm/Manager.h>
#include <Xm/ScrolledW.h>

class ScrolledWindowClass: public ManagerClass {
 protected:
   ScrolledWindowClass() {} /* only a derived class can make this */
   virtual WidgetClass classPointer()  { return xmScrolledWindowWidgetClass; }
   virtual _XtString className()       { return (_XtString) "XmScrolledWindow"; }
 public:
   /* callbacks */
   void traverseObscuredCallback(XtCallbackProc fp, XtPointer data = NULL)
                                       { XARM_SET_CALLBACK(XmNtraverseObscuredCallback); }

   /* resources */
   Widget horizontalScrollBar() const                { XARM_GET_VALUE(Widget, XmNhorizontalScrollBar); }
   void horizontalScrollBar(Widget val)              { XARM_SET_VALUE(XmNhorizontalScrollBar); }
   void scrollBarDisplayPolicy(unsigned char val)    { XARM_SET_VALUE(XmNscrollBarDisplayPolicy); }
   unsigned char scrollBarDisplayPolicy() const
                                           { XARM_GET_VALUE(unsigned char, XmNscrollBarDisplayPolicy); }
   void scrollBarPlacement(unsigned char val)        { XARM_SET_VALUE(XmNscrollBarPlacement); }
   unsigned char scrollBarPlacement() const
                                           { XARM_GET_VALUE(unsigned char, XmNscrollBarPlacement); }
   void scrolledWindowMarginHeight(Dimension val)    { XARM_SET_VALUE(XmNscrolledWindowMarginHeight); }
   Dimension scrolledWindowMarginHeight() const
                                           { XARM_GET_VALUE(Dimension, XmNscrolledWindowMarginHeight); }
   void scrolledWindowMarginWidth(Dimension val)     { XARM_SET_VALUE(XmNscrolledWindowMarginWidth); }
   Dimension scrolledWindowMarginWidth() const
                                           { XARM_GET_VALUE(Dimension, XmNscrolledWindowMarginWidth); }
   unsigned char scrollingPolicy() const
                                           { XARM_GET_VALUE(unsigned char, XmNscrollingPolicy); }
   void spacing(int val)                             { XARM_SET_VALUE(XmNspacing); }
   int spacing() const                               { XARM_GET_VALUE(int, XmNspacing); }
   Widget verticalScrollBar() const                  { XARM_GET_VALUE(Widget, XmNverticalScrollBar); }
   void verticalScrollBar(Widget val)                { XARM_SET_VALUE(XmNverticalScrollBar); }
   unsigned char visualPolicy() const                { XARM_GET_VALUE(unsigned char, XmNvisualPolicy); }
   void workWindow(Widget val)                       { XARM_SET_VALUE(XmNworkWindow); }
   Widget workWindow() const                         { XARM_GET_VALUE(Widget, XmNworkWindow); }

   /* convenience routines */
   void setArea(Widget hscroll, Widget vscroll, Widget work)
                           { XmScrolledWindowSetAreas(widget(), hscroll, vscroll, work); }
};

typedef XarmRawWidget<ScrolledWindowClass, false> ScrolledWindow;

#endif
