#ifndef _XmDial_h
#define _XmDial_h

#include <Xm/Xm.h>

typedef enum _dialStyle { MeterStyle,
                          PointerStyle
                        } DialStyle;

/* Dial Widget */

#define XmNstyle          "style"
#define XmNfill           "fill"
#define XmNtickIncrement  "tickIncrement"
#define XmNtickSize       "tickSize"
#define XmNborderMargin   "borderMargin"
#define XmNarcMargin      "arcMargin"
#define XmNshowPercentage "showPercentage"
#define XmNshowMinMax 	  "showMinMax"
#define XmNshowHub 	  "showHub"

#define XmCStyle          "Style"
#define XmCFill           "Fill"
#define XmCTickIncrement  "TickIncrement"
#define XmCTickSize       "TickSize"
#define XmCBorderMargin   "BorderMargin"
#define XmCArcMargin      "ArcMargin"
#define XmCShowPercentage "ShowPercentage"
#define XmCShowMinMax     "ShowMinMax"
#define XmCShowHub        "ShowHub"

#define XmDIAL            "dial"
#define XmDIAL_POINTER    "pointer"
#define XmBORDER_MARGIN   "border_margin"
#define XmARC_MARGIN      "arc_margin"

externalref WidgetClass xmDialWidgetClass;

typedef struct _XmDialClassRec *XmDialWidgetClass;
typedef struct _XmDialRec      *XmDialWidget;

#ifndef XmIsDial
#define XmIsDial(w) XtIsSubclass(w, xmDialWidgetClass)
#endif 

/* Dial externs for application accessible functions */

#ifdef _NO_PROTO
extern Widget XmCreateDial ();
#else 

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

extern Widget XmCreateDial (Widget   parent, 
                            char    *name, 
                            ArgList  arglist, 
                            Cardinal argcount);
#endif

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
