#ifndef INCL_MENU_H
#define INCL_MENU_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/Ddraw.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/gadget.h>

#define REASON_INOTHERMENU	1	// proof: menu*
#define REASON_SUBWINDOW	2	// proof: Xwindows* with TransientFor()
#define REASON_SUID			3	// proof: NULL, getuid()!=geteuid()

class menu : public gadget, private Ddraw
{
	friend class pmenu;
	
	class pmenu *p;

public:
    virtual void GExpose(XEvent *event);
    virtual void GActionPress(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
    virtual void GActionRelease(int mx,int my,int rx,int ry,unsigned int state,int button,int reason);
	virtual void GSetLimits(void);
	virtual int GActivate(XEvent *event,int why);
	virtual int GSelected(XEvent *event,int why,int wasabove);
    virtual int GMouseMove(int mx,int my,int rx,int ry,unsigned int state,int button);

    menu();
    virtual ~menu();

	int Create();
	void Free(void);

	void Resize(int w,int h);
	void Lock(void);
	void Unlock(void);
    void Block(int);
    void Unblock(int);

	virtual void LockItem(int menu,int id);
	virtual void UnlockItem(int menu,int id);
	virtual void LockHeadOf(int menu,int id);
	virtual void UnlockHeadOf(int menu,int id);

	virtual void State(int menu,int id,int state);
	virtual int State(int menu,int id);

	virtual void Selected(int menu,int id,int s);
	virtual int Selected(int menu,int id);

	void AddMenu(char *);
	void AddHelpMenu(char *);
	void Add(char *text,char *scut,int id);
	void Add(char *text,int id) { Add(text,NULL,id); };
	void AddRuler(void);
	void AddHeadline(char *);
	void AddSel(char *text,char *scut,int id);
	void AddSel(char *text,int id) { AddSel(text,NULL,id); };
	void AddMX(char **text,char **scut,int id);
	void AddMX(char **text,int id) { AddMX(text,NULL,id); };
	void AddSub(char *text);
	void EndSub(void);
	void NoHelpMenu(int reason,void *proof);

	void Clear(void);
	void Recreate(void);

	virtual int Menu(void);
	virtual int MID(void);
	virtual unsigned int Selection(void);	// bits 0-23: ID, 24-31: menu
};

#endif
