/* ****************************** -*-c++-*- *******************************/
/* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/


/* Advanced and internal stuff for widgets
   
   Designed and implemented by Brad Myers
*/

#ifndef WIDGETS_ADVANCED_H
#define WIDGETS_ADVANCED_H

#include <am_inc.h>

#include WIDGETS__H 
#include GEM__H
#include TYPES__H
#include UNIV_MAP__H
#include WEB__H

#include VALUE_LIST__H

extern void Am_Widgets_Initialize ();

////////////////////////////////////////////////////////////////////////
//  Color Utility Functions
////////////////////////////////////////////////////////////////////////

extern Am_Formula Am_Default_Motif_Fill_Style;
     
class Computed_Colors_Record_Data : public Am_Wrapper {
  Am_WRAPPER_DATA_DECL (Computed_Colors_Record)
public:
  // constructor
  Computed_Colors_Record_Data ()
  {
    refs = 2;
  }
  Computed_Colors_Record_Data (const Am_Style& foreground);
  Computed_Colors_Record_Data (Computed_Colors_Record_Data*);
  operator== (Computed_Colors_Record_Data&)
  { return false; }
  // destructor
  ~Computed_Colors_Record_Data ();

  Am_Style foreground_style;
  Am_Style background_style;
  Am_Style shadow_style;
  Am_Style highlight_style;
  Am_Style menu_top_line_style;  // shadow, linethickness 1
  Am_Style menu_bottom_line_style; // highlight, linethickness 1
};

class Computed_Colors_Record {
public:
  // constructors
  Computed_Colors_Record ()
  {
    data = NULL;
  }
  Computed_Colors_Record (const Am_Style& foreground);
  Computed_Colors_Record (const Am_Value& in_value)
  {
    data = (Computed_Colors_Record_Data*)in_value.value.wrapper_value;
    if (data)
      data->Note_Reference ();
  }
  Computed_Colors_Record (Computed_Colors_Record_Data* in_data)
  {
    data = in_data;
  }

  // destructor
  ~Computed_Colors_Record ()
  {
    if (data)
      data->Release ();
    data = NULL;
  }

  operator Am_Wrapper* () const
  {
    if (data)
      data->Note_Reference ();
    return data;
  }

  Computed_Colors_Record_Data* data;
};

//////// define the hash table from a style to a Motif_Colors_Record //////

inline int HashValue (Am_Wrapper* key, int size)
{
  return HashValue ((const void*)key, size);
}

inline int KeyComp (Am_Wrapper* key1, Am_Wrapper* key2)
{
  return KeyComp ((const void*)key1, (const void*)key2);
}

Am_DECL_MAP (Style2MotifRec, Am_Wrapper*, Computed_Colors_Record_Data*)

extern Am_Object Am_Button_In_Panel; // button that is part of a panel

extern Am_Style Am_Motif_Inactive_Stipple; // text draw style when inactive
extern Am_Style Am_Key_Border_Line;

extern Am_Object Am_Pop_Up_Window_Proto;

////////////////// Interface between widgets.cc and the various widget files

extern Am_Formula Am_Get_Computed_Colors_Record_Form;


extern void Am_Draw_Motif_Box (int left, int top, int width, int height,
			       bool depressed,
			       const Computed_Colors_Record& rec,
			       Am_Drawonable* draw);

extern Am_Formula Am_Active_From_Command;
extern Am_Formula Am_Active_And_Active2;
extern Am_Formula Am_Get_Owners_Command;
extern Am_Formula Am_Get_Real_String_Or_Obj;
extern Am_Formula Am_Get_Button_Command_Value;
extern Am_Formula Am_Font_From_Owner;

extern void Am_Widget_General_Undo_Redo(Am_Object command_obj,
					bool undo, bool selective);
extern Am_Object_Method Am_Widget_Inter_Command_Undo;
extern Am_Object_Method Am_Widget_Inter_Command_Selective_Undo;
extern Am_Object_Method Am_Widget_Inter_Command_Selective_Repeat;


//buttons
enum Am_Button_Type { Am_PUSH_BUTTON, Am_RADIO_BUTTON, Am_CHECK_BUTTON };

extern void Am_Button_Widgets_Initialize ();

//scroll bars

enum Am_Scroll_Arrow_Direction { Am_SCROLL_ARROW_UP, Am_SCROLL_ARROW_DOWN, 
				 Am_SCROLL_ARROW_LEFT, Am_SCROLL_ARROW_RIGHT};


//used to make the individual scroll-indicator drags not queued for undo
#define Am_MARKER_FOR_SCROLL_INC -2

extern void Am_Scroll_Widgets_Initialize ();

//text input

  ///////////////////////////////////////////////////////////////////////////
  // Scrolling Text Input Widget
  ///////////////////////////////////////////////////////////////////////////

extern void Am_Text_Widgets_Initialize ();

  ///////////////////////////////////////////////////////////////////////////
  // Selection Handles
  ///////////////////////////////////////////////////////////////////////////

extern Am_Object Am_One_Selection_Handle;
extern void Am_Selection_Widget_Initialize ();

//Am_Compute_MG_Feedback_Object just exported for testselectionwidget
extern Am_Formula Am_Compute_MG_Feedback_Object;

  ///////////////////////////////////////////////////////////////////////////
  // Graphical Editing Commands
  ///////////////////////////////////////////////////////////////////////////
extern void Am_Editing_Commands_Initialize ();
extern Am_Selective_Allowed_Method Am_Selective_Allowed_Return_False;
extern Am_Selective_New_Allowed_Method Am_Selective_New_Allowed_Return_False;

  // useful utilities for editing commands
extern Am_Value_List Am_Copy_Object_List(Am_Value_List orig, int offset = 0);
extern Am_Formula Am_Active_If_Selection;
extern Am_Value_List Am_Sort_Obs_In_Group(Am_Value_List unsorted_sel_objs,
					  Am_Object group);
extern void Am_Get_Selection_In_Display_Order(Am_Object selection_widget,
					      Am_Value_List &selected_objs,
					      Am_Object &group);
extern Am_Object Am_Find_Part_Place(Am_Object obj, Am_Object group);




///////////////////////////////////////////////////////////////////////////
// Accelerators for buttons
///////////////////////////////////////////////////////////////////////////

extern Am_Object Am_Accelerator_Inter;
extern void Am_Add_Accelerator_Command_To_Window(Am_Object command,
						 Am_Object window);
extern void Am_Remove_Accelerator_Command_From_Window(Am_Object command,
						      Am_Object window);

///////////////////////////////////////////////////////////////////////////
// Methods for start, stop and abort widget
///////////////////////////////////////////////////////////////////////////

Am_Define_Method_Type(Am_Explicit_Widget_Run_Method, void,
		      (Am_Object widget, Am_Value new_value))

extern Am_Explicit_Widget_Run_Method Am_Standard_Widget_Start_Method;
extern Am_Object_Method 	     Am_Standard_Widget_Abort_Method;
extern Am_Explicit_Widget_Run_Method Am_Standard_Widget_Stop_Method;

///////////////////////////////////////////////////////////////////////////
// Dialog boxes
///////////////////////////////////////////////////////////////////////////

extern void Am_Dialog_Widgets_Initialize ();

#endif
