 /* ************************************************************************ 
 *         The Amulet User Interface Development Environment              *
 * ************************************************************************
 * This code was written as part of the Amulet project at                 *
 * Carnegie Mellon University, and has been placed in the public          *
 * domain.  If you are using this code or any part of Amulet,             *
 * please contact amulet@cs.cmu.edu to be put on the mailing list.        *
 * ************************************************************************/

// gem_GIF.h
//
// GIF machine independant image format class.

#include "gem_image.h"
#include <fstream.h>

// GIF format constants 
#define HAS_CT      0x80 // has a colortable
#define INTERLACED  0x40 // interlaced image
#define CTSIZE(x)   (x & 0x07)

#define GIF_IMGSTART ','
#define GIF_EXTSTART '!'
#define GIF_TRAILER  ';'
#define GIF_COMMENT  0xfe

#define GIF_MAXCODE   12
#define GIF_TBLSIZE   4096

// Structures for GIF blocks

struct GIFHeader
{
  char   signature[3]; // Should contain: "GIF"
  char   version[3];   // "87a" or "89a"
};
#define GIF_SIG_LEN  6          /* GIF signature length */
#define GIF_SD_SIZE  7          /* GIF screen descriptor size */
#define GIF_ID_SIZE  9          /* GIF image descriptor size */

// Structure for GIF file information
// Eventually we should completely get rid of this structure, currently
// used to pass information between Am_GIF_Image routines.  The data
// is only needed temporarily, so it shouldnt be put in Am_GIF_Image.
class GIF_Load_Info
{
public:
  GIFHeader      hdr;
  unsigned short interlaced;
  unsigned short pass; // For interlaced images
  unsigned short x, y; // position in image
};

class Am_GIF_Image: public Am_Generic_Image
{
public:
  static Am_Generic_Image* Create(const char* filename);
protected:
  int process_gif(ifstream &ifs, GIF_Load_Info& gli);
  void add_to_image(GIF_Load_Info& gli, unsigned short pixval);
  int load_gif_colormap(ifstream &ifs, int flags);
};
