#include "DialogPropDialog.h"

#include "Dialog.h"
#include "WidgetLayout.h"

#define Inherited DialogPropDialogData

DialogPropDialog::DialogPropDialog
(
    Dialog* dialog,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name ),
    itsBasePage( dialog, this, "BasePage" ),
    itsGenPage( dialog, this, "GenPage" ),
    itsWindowPage( dialog, this, "WindowPage" ),
    itsGeometryPage( dialog, this, "GeometryPage" ),
    itsBoxLayoutPage( dialog->itsLayout->itsBoxLayout, this, "BoxLayoutPage" ),
    itsDialog( dialog )
{
    setCaption( "Window Properties" );

    addTab( &itsBasePage, "Base class" );
    addTab( &itsGenPage, "File Generation" );
    addTab( &itsWindowPage, "Window" );
    addTab( &itsGeometryPage, "Geometry" );
    addTab( &itsBoxLayoutPage, "Box Layout" );
    
    setCancelButton();
    
    connect( this, SIGNAL(applyButtonPressed()), SLOT(Apply()) );
    connect( &itsWindowPage, 
	     SIGNAL(LayoutTypeChanged(WidgetLayout::LayoutType)),
	     SLOT(LayoutTypeChanged(WidgetLayout::LayoutType)) );

    LayoutTypeChanged( dialog->itsLayout->GetLayoutType() );
}


DialogPropDialog::~DialogPropDialog()
{
}


void DialogPropDialog::Apply()
{
    itsBasePage.Apply( itsDialog );
    itsGenPage.Apply( itsDialog );
    itsWindowPage.Apply( itsDialog );
    itsGeometryPage.Apply( itsDialog );

    switch( itsDialog->itsLayout->GetLayoutType() )
    {
	case WidgetLayout::None:
	{
	    break;
	}
	case WidgetLayout::Box:
	{
	    itsBoxLayoutPage.Apply( itsDialog->itsLayout->itsBoxLayout );
	    break;
	}
    }
}


void DialogPropDialog::LayoutTypeChanged
(
    WidgetLayout::LayoutType	type
)
{
    bool isBox = FALSE;
    
    switch( type )
    {
	case WidgetLayout::None:
	{
	    break;
	}
	case WidgetLayout::Box:
	{
	    isBox = TRUE;
	}
    }
    
    setTabEnabled( "BoxLayoutPage", isBox );
}

