#include "widget/Button.h"

#define Inherited QButton

Button::Button
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( widget, name )
{
}


void Button::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void Button::mouseDoubleClickEvent( QMouseEvent*	event )
{
    emit MouseDoubleClick( this, event );
}


void Button::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void Button::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void Button::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void Button::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this, event );
}


void Button::moveEvent
(
    QMoveEvent*	event
)
{
    Inherited::moveEvent( event );
    
    emit Move( this, event );
}
