/****************************************************************************
** $Id: qembed.cpp,v 1.2 1997/04/17 03:20:53 jharris Exp $
**
** Utility program for embedding binary data into a C/C++ source code.
**
** Copyright (C) 1995 by Troll Tech AS.  Use, modification and
** distribution is allowed without limitation, warranty, or liability
** of any kind.
**
*****************************************************************************/

#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <qtstream.h>
#include <qdatetm.h>
#include <ctype.h>


void    embedData( const QByteArray &input, QFile *output );
QString convertFileNameToCIdentifier( const char * );

int main( int argc, char **argv )
{
    if ( argc < 4 ) {
	warning( "Usage:\n\t%s header source files", argv[0] );
	return 1;
    }

    QFile source( argv[2] ), header( argv[1] );
    source.open( IO_WriteOnly );
    header.open( IO_WriteOnly );

    QTextStream sourceStream( &source );
    QTextStream headerStream( &header );

    sourceStream << "#include \"bmp/" << argv[1] << "\"\n";

  // Embed data for all input files

    QString cname;
    
    for ( int i=3; i<argc; i++ ) {
	QFile f( argv[i] );
	if ( !f.open(IO_ReadOnly) ) {
	    warning( "Cannot open file %s, ignoring it", argv[i] );
	    continue;
	}
	QByteArray a( f.size() );
	if ( f.readBlock(a.data(), f.size()) != (int)f.size() ) {
	    warning( "Cannot read file %s, ignoring it", argv[i] );
	    f.close();
	    continue;
	}

	cname = convertFileNameToCIdentifier( argv[i] );

	headerStream << "extern const unsigned int " << cname << "_len;\n";
	headerStream << "extern const unsigned char " << cname << 
	    "_data[];\n\n";

	sourceStream << "const unsigned int " << cname << "_len = " <<
	    f.size() << ";\n";
	sourceStream << "const unsigned char " << cname << "_data[] = {";

	embedData( a, &source );
	sourceStream << "\n};\n\n";
	f.close();
    }

    return 0;
}


QString convertFileNameToCIdentifier( const char *s )
{
    QString r = s;
    int len = r.length();
    if ( len > 0 && !isalpha(r[0]) )
	r[0] = '_';
    for ( int i=1; i<len; i++ ) {
	if ( !isalnum(r[i]) )
	    r[i] = '_';
    }
    return r;
}


void embedData( const QByteArray &input, QFile *output )
{
    static char hexdigits[] = "0123456789abcdef";
    QString s( 100 );
    int nbytes = input.size();
    char *p = s.data();
    for ( int i=0; i<nbytes; i++ ) {
	if ( (i%14) == 0 ) {
	    strcpy( p, "\n    " );
	    output->writeBlock( s.data(), s.length() );
	    p = s.data();
	}
	int v = (int)((uchar)input[i]);
	*p++ = '0';
	*p++ = 'x';
	*p++ = hexdigits[(v >> 4) & 15];
	*p++ = hexdigits[v & 15];
	if ( i < nbytes-1 )
	    *p++ = ',';
    }
    if ( p > s.data() ) {
	*p = '\0';
	output->writeBlock( s.data(), s.length() );
    }
}
