/**********************************************************************

	--- dlgedit generated file ---

	File: BoxLayoutPropPage.cpp
	Last generated: Fri May 2 14:17:25 1997

 *********************************************************************/

#include <qstring.h>
#include <qstrlist.h>

#include "layout/BoxLayoutPropPage.h"
#include "layout/BoxLayout.h"

#define Inherited BoxLayoutPropPageData

BoxLayoutPropPage::BoxLayoutPropPage
(
    BoxLayout*	layout,
    QWidget*	parent,
    const char*	name
)
    :
    Inherited( parent, name ),
    itsLayout( layout )
{
    BoxLayout newLayout( NULL, NULL );

    if( !layout )
    {
	layout = &newLayout;
    }

    switch( layout->GetDirection() )
    {
	case QBoxLayout::LeftToRight:
	{
	    isLeftToRight->setChecked( TRUE );
	    break;
	}
	case QBoxLayout::RightToLeft:
	{
	    isRightToLeft->setChecked( TRUE );
	    break;
	}
	case QBoxLayout::TopToBottom:
	{
	    isTopToBottom->setChecked( TRUE );
	    break;
	}
	case QBoxLayout::BottomToTop:
	{
	    isBottomToTop->setChecked( TRUE );
	    break;
	}
    }
    
    QString str;

    itsBorder->setEnabled( layout->IsTopLevel() );
    itsBorderLabel->setEnabled( layout->IsTopLevel() );
    itsBorder->setText( str.setNum( layout->GetBorder() ) );

    itsAutoBorder->setText( str.setNum( layout->GetAutoBorder() ) );
    itsStrut->setText( str.setNum( layout->GetStrut() ) );

    itsStretch->setEnabled( !layout->IsTopLevel() );
    itsStretchLabel->setEnabled( !layout->IsTopLevel() );
    itsStretch->setText( str.setNum( layout->GetStretch() ) );

    itsName->setText( layout->GetName() );

    // insert names of menu bars into combo box
    QStrList menus;
    layout->GetMenuBarNames( menus );

    itsMenuBars->insertItem( "(None)" );
    itsMenuBars->insertStrList( &menus );

    QString menuName = layout->GetMenuBarName();
    int index = 0;

    if( !menuName.isEmpty() )
    {
	index = menus.find( menuName );
	if( index == -1 )
	{
	    index = 0;
	}
	else
	{
	    // account for the "(None)" entry
	    ++index;
	}
    }
    
    itsMenuBars->setCurrentItem( index );
}


BoxLayoutPropPage::~BoxLayoutPropPage()
{
}


void BoxLayoutPropPage::Apply
(
    BoxLayout*	layout
)
{
    if( layout )
    {
	QBoxLayout::Direction dir = QBoxLayout::LeftToRight;
    
	if( isRightToLeft->isChecked() )
	{
	    dir = QBoxLayout::RightToLeft;
	}
	else if( isTopToBottom->isChecked() )
	{
	    dir = QBoxLayout::TopToBottom;
	}
	else if( isBottomToTop->isChecked() )
	{
	    dir = QBoxLayout::BottomToTop;
	}
    
	layout->SetDirection( dir );
    
	QString str;
    
	str = itsBorder->text();
	layout->SetBorder( str.toInt() );
    
	str = itsAutoBorder->text();
	layout->SetAutoBorder( str.toInt() );

	str = itsStrut->text();
	layout->SetStrut( str.toInt() );

	str = itsStretch->text();
	layout->SetStretch( str.toInt() );
    
	layout->SetName( itsName->text() );

	str = "";
	if( itsMenuBars->currentItem() > 0 )
	{
	    str = itsMenuBars->currentText();
	}
	layout->SetMenuBar( str );
    }
}


void BoxLayoutPropPage::Apply( void )
{
    Apply( itsLayout );
}
